/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import com.google.common.collect.ImmutableList;
import jagm.jagmkiwis.KiwiEntity;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class KiwiModel<T extends Entity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation KIWI_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"jagmkiwis", (String)"kiwi"), "main");
    private final ModelPart head;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart body;
    private float headXRot;

    public KiwiModel(ModelPart root) {
        super(false, 2.0f, 0.5f);
        this.head = root.getChild("head");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 10).addBox(-1.0f, -0.5f, -7.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)17.5f, (float)-1.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(15, 0).addBox(-1.5f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-1.0f, 1.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(21, 3).addBox(-2.0f, 3.5f, -2.5f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)20.5f, (float)2.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(15, 0).addBox(-1.5f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-1.0f, 1.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(21, 3).addBox(-2.0f, 3.5f, -2.5f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)20.5f, (float)2.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -2.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)19.5f, (float)1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        KiwiEntity kiwi = (KiwiEntity)((Object)entity);
        this.head.y = 17.5f + kiwi.getHeadEatPositionScale(partialTicks);
        this.headXRot = kiwi.getHeadEatAngleScale(partialTicks);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = this.headXRot;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }
}

