/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiModSounds;
import java.util.EnumSet;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class KiwiDigGoal
extends Goal {
    private final Mob mob;
    public static final ResourceKey<LootTable> DIGGING_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jagmkiwis", (String)"entities/kiwi_diggables"));
    private int digAnimationTick;

    public KiwiDigGoal(Mob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.mob.isBaby() || this.mob.getRandom().nextInt(3000) != 0) {
            return false;
        }
        return this.mob.level().getBlockState(this.mob.blockPosition().below()).is(BlockTags.DIRT);
    }

    public void start() {
        this.digAnimationTick = this.adjustedTickDelay(40);
        this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)10);
        this.mob.getNavigation().stop();
    }

    public void stop() {
        this.digAnimationTick = 0;
    }

    public boolean canContinueToUse() {
        return this.digAnimationTick > 0;
    }

    public void tick() {
        Level level;
        this.digAnimationTick = Math.max(this.digAnimationTick - 1, 0);
        if (this.digAnimationTick == this.adjustedTickDelay(4) && (level = this.mob.level()).getServer() != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.mob.isAlive()) {
                this.mob.playSound((SoundEvent)KiwiModSounds.KIWI_DIG.get(), 1.0f, (this.mob.getRandom().nextFloat() - this.mob.getRandom().nextFloat()) * 0.2f + 1.0f);
                LootTable diggingLoot = serverLevel.getServer().reloadableRegistries().getLootTable(DIGGING_LOOT);
                LootParams.Builder lootParams$builder = new LootParams.Builder(serverLevel);
                LootParams lootParams = lootParams$builder.create(LootContextParamSets.EMPTY);
                diggingLoot.getRandomItems(lootParams, this.mob.getLootTableSeed(), arg_0 -> ((Mob)this.mob).spawnAtLocation(arg_0));
                this.mob.gameEvent((Holder)GameEvent.ENTITY_PLACE);
            }
        }
    }

    public int getDigAnimationTick() {
        return this.digAnimationTick;
    }
}

