/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.red_panda.entity;

import com.cozary.red_panda.init.ModEntityTypes;
import com.cozary.red_panda.init.ModSound;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LandOnOwnersShoulderGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RedPandaEntity
extends ShoulderRidingEntity {
    static final Predicate<ItemEntity> ALLOWED_ITEMS = itemEntity -> {
        ItemStack itemstack = itemEntity.getItem();
        return !itemEntity.hasPickUpDelay() && itemEntity.isAlive() && (itemstack.is(Blocks.BAMBOO.asItem()) || itemstack.is(Items.SWEET_BERRIES) || itemstack.is(Items.EGG));
    };
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> EAT_BAMBOO_COUNTER = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Predicate<Entity> AVOID_PLAYERS = p_28463_ -> !p_28463_.isDiscrete() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(p_28463_);
    private static final Ingredient FOOD_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES, Items.EGG, Items.BAMBOO});

    public RedPandaEntity(EntityType<? extends RedPandaEntity> p_28451_, Level p_28452_) {
        super(p_28451_, p_28452_);
        this.lookControl = new RedPandaEntityLookControl();
        this.moveControl = new RedPandaEntityMoveControl();
        this.setPathfindingMalus(PathType.DANGER_OTHER, 0.0f);
        this.setCanPickUpLoot(true);
        this.setTame(false, false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.MAX_HEALTH, 15.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 2.5);
    }

    public static boolean checkRedPandaEntitySpawnRules(EntityType<? extends RedPandaEntity> creeper, ServerLevelAccessor p_186215_, MobSpawnType p_186216_, BlockPos p_186217_, RandomSource p_186218_) {
        return p_186215_.getBlockState(p_186217_.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && RedPandaEntity.isBrightEnoughToSpawn((BlockAndTintGetter)p_186215_, (BlockPos)p_186217_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(EAT_BAMBOO_COUNTER, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RedPandaEntityFloatGoal());
        this.goalSelector.addGoal(2, (Goal)new LandOnOwnersShoulderGoal((ShoulderRidingEntity)this));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new RedPandaSearchForPlayerItemsGoal());
        this.goalSelector.addGoal(2, (Goal)new RedPandaEntityPanicGoal(this, 2.2));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.6, 1.4, p_28596_ -> AVOID_PLAYERS.test((Entity)p_28596_) && this.getOwnerUUID() != p_28596_.getUUID()));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 8.0f, 1.6, 1.4, p_28590_ -> !((Wolf)p_28590_).isTame()));
        this.goalSelector.addGoal(6, (Goal)new SeekShelterGoal(1.25));
        this.goalSelector.addGoal(7, (Goal)new SleepGoal());
        this.goalSelector.addGoal(8, (Goal)new RedPandaEntityFollowParentGoal(this, this, 1.25));
        this.goalSelector.addGoal(1, (Goal)new RedPandaEntityEatBambooGoal(1.2f, 12, 1));
        this.goalSelector.addGoal(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(12, (Goal)new RedPandaEntityLookAtPlayerGoal(this, (Mob)this, Player.class, 24.0f));
        this.goalSelector.addGoal(13, (Goal)new PerchAndSearchGoal());
        this.goalSelector.addGoal(0, (Goal)new FoxSearchForItemsGoal());
    }

    protected void pickUpItem(@NotNull ItemEntity p_29121_) {
        if (this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty() && ALLOWED_ITEMS.test(p_29121_) && FOOD_ITEMS.test(p_29121_.getItem())) {
            this.onItemPickup(p_29121_);
            ItemStack itemstack = p_29121_.getItem();
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
            this.handDropChances[EquipmentSlot.MAINHAND.getIndex()] = 2.0f;
            this.take((Entity)p_29121_, itemstack.getCount());
            p_29121_.discard();
        }
    }

    public boolean canSitOnShoulder() {
        return !this.isBaby();
    }

    @NotNull
    public SoundEvent getEatingSound(@NotNull ItemStack p_28540_) {
        return ModSound.RED_PANDA_EAT.get();
    }

    public void aiStep() {
        if (this.isSleeping() || this.isImmobile()) {
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        super.aiStep();
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    public RedPandaEntity getBreedOffspring(@NotNull ServerLevel p_148912_, @NotNull AgeableMob p_148913_) {
        RedPandaEntity redPandaEntity = (RedPandaEntity)ModEntityTypes.RED_PANDA.get().create((Level)p_148912_);
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            assert (redPandaEntity != null);
            redPandaEntity.setOwnerUUID(uuid);
            redPandaEntity.setTame(true, true);
        }
        return redPandaEntity;
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand p_30413_) {
        ItemStack itemstack = player.getItemInHand(p_30413_);
        FoodProperties foodProperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
        if (this.level().isClientSide) {
            boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame() || FOOD_ITEMS.test(itemstack) && !this.isTame();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                if (itemstack.getItem() != Items.BAMBOO && foodProperties != null) {
                    this.heal(foodProperties.nutrition());
                }
                return InteractionResult.SUCCESS;
            }
        } else if (FOOD_ITEMS.test(itemstack)) {
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            if (this.random.nextInt(3) == 0) {
                this.tame(player);
                this.navigation.stop();
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, p_30413_);
    }

    @NotNull
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_28487_, @NotNull DifficultyInstance p_28488_, @NotNull MobSpawnType p_28489_, @NotNull SpawnGroupData p_28490_) {
        Holder holder = p_28487_.getBiome(this.blockPosition());
        boolean flag = false;
        if (flag) {
            this.setAge(-24000);
        }
        return super.finalizeSpawn(p_28487_, p_28488_, p_28489_, p_28490_);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag p_28518_) {
        super.addAdditionalSaveData(p_28518_);
        p_28518_.putBoolean("Scared", this.isScared());
        p_28518_.putBoolean("Sleeping", this.isSleeping());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag p_28493_) {
        super.readAdditionalSaveData(p_28493_);
        this.setSleeping(p_28493_.getBoolean("Scared"));
        this.setSleeping(p_28493_.getBoolean("Sleeping"));
    }

    public boolean isSleeping() {
        return this.getFlag(32);
    }

    void setSleeping(boolean p_28627_) {
        this.setFlag(32, p_28627_);
    }

    public boolean isScared() {
        return this.getFlag(2);
    }

    void setScared(boolean p_28627_) {
        this.setFlag(2, p_28627_);
    }

    private void setFlag(int p_28533_, boolean p_28534_) {
        if (p_28534_) {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS_ID) | p_28533_)));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS_ID) & ~p_28533_)));
        }
    }

    private boolean getFlag(int p_28609_) {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & p_28609_) != 0;
    }

    public void tick() {
        boolean flag;
        super.tick();
        if (this.isEffectiveAi() && ((flag = this.isInWater()) || this.getTarget() != null || this.level().isThundering())) {
            this.wakeUp();
        }
        this.handleEating();
    }

    public boolean isEating() {
        return (Integer)this.entityData.get(EAT_BAMBOO_COUNTER) > 0;
    }

    public void eat(boolean p_29217_) {
        this.entityData.set(EAT_BAMBOO_COUNTER, (Object)(p_29217_ ? 1 : 0));
    }

    private int getEatCounter() {
        return (Integer)this.entityData.get(EAT_BAMBOO_COUNTER);
    }

    private void setEatCounter(int p_29215_) {
        this.entityData.set(EAT_BAMBOO_COUNTER, (Object)p_29215_);
    }

    private void handleEating() {
        if (!this.isEating() && !this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty() && this.random.nextInt(80) == 1) {
            this.eat(true);
        } else if (this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
            this.eat(false);
        }
        if (this.isEating()) {
            this.addEatingParticles();
            if (!this.level().isClientSide && this.getEatCounter() > 10) {
                if (!this.level().isClientSide) {
                    if (this.getItemBySlot(EquipmentSlot.MAINHAND).getCount() > 1) {
                        ItemStack newBamboo = new ItemStack((ItemLike)Items.BAMBOO);
                        newBamboo.setCount(this.getItemBySlot(EquipmentSlot.MAINHAND).getCount() - 1);
                        this.setItemSlot(EquipmentSlot.MAINHAND, newBamboo);
                        this.eat(false);
                        this.setEatCounter(0);
                        return;
                    }
                    this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                }
                this.eat(false);
                this.setEatCounter(0);
                return;
            }
            this.setEatCounter(this.getEatCounter() + 1);
        }
    }

    private void addEatingParticles() {
        if (this.getEatCounter() % 5 == 0) {
            this.playSound(ModSound.RED_PANDA_EAT.get(), 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            for (int i = 0; i < 6; ++i) {
                Vec3 vec3 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.random.nextFloat() - 0.5) * 0.1);
                vec3 = vec3.xRot(-this.getXRot() * ((float)Math.PI / 180));
                vec3 = vec3.yRot(-this.getYRot() * ((float)Math.PI / 180));
                double d0 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
                Vec3 vec31 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.8, d0, 1.0 + ((double)this.random.nextFloat() - 0.5) * 0.4);
                vec31 = vec31.yRot(-this.yBodyRot * ((float)Math.PI / 180));
                vec31 = vec31.add(this.getX(), this.getEyeY() + 1.0, this.getZ());
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItemBySlot(EquipmentSlot.MAINHAND)), vec31.x, vec31.y, vec31.z, vec3.x, vec3.y + 0.05, vec3.z);
            }
        }
    }

    public boolean isFood(@NotNull ItemStack p_28594_) {
        return FOOD_ITEMS.test(p_28594_);
    }

    protected int calculateFallDamage(float p_28545_, float p_28546_) {
        return Mth.ceil((float)((p_28545_ - 7.0f) * p_28546_));
    }

    void wakeUp() {
        this.setSleeping(false);
    }

    void clearStates() {
        this.setScared(false);
        this.setSleeping(false);
    }

    boolean canMove() {
        return !this.isSleeping() && !this.isScared();
    }

    public void playAmbientSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent == ModSound.RED_PANDA_SCREECH.get()) {
            this.playSound(soundevent, 2.0f, this.getVoicePitch());
        } else {
            super.playAmbientSound();
        }
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        List list;
        if (this.isSleeping()) {
            return ModSound.RED_PANDA_SLEEP.get();
        }
        if (!this.level().isDay() && this.random.nextFloat() < 0.1f && (list = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(16.0, 16.0, 16.0), EntitySelector.NO_SPECTATORS)).isEmpty()) {
            return ModSound.RED_PANDA_SCREECH.get();
        }
        return ModSound.RED_PANDA_AMBIENT.get();
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource p_28548_) {
        return ModSound.RED_PANDA_HURT.get();
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return ModSound.RED_PANDA_DEATH.get();
    }

    @NotNull
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.55f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    public class RedPandaEntityLookControl
    extends LookControl {
        public RedPandaEntityLookControl() {
            super((Mob)RedPandaEntity.this);
        }

        public void tick() {
            if (!RedPandaEntity.this.isSleeping() && !RedPandaEntity.this.isScared()) {
                super.tick();
            }
        }

        protected boolean resetXRotOnTick() {
            return !RedPandaEntity.this.isCrouching();
        }
    }

    class RedPandaEntityMoveControl
    extends MoveControl {
        public RedPandaEntityMoveControl() {
            super((Mob)RedPandaEntity.this);
        }

        public void tick() {
            if (RedPandaEntity.this.canMove()) {
                super.tick();
            }
        }
    }

    class RedPandaEntityFloatGoal
    extends FloatGoal {
        public RedPandaEntityFloatGoal() {
            super((Mob)RedPandaEntity.this);
        }

        public void start() {
            super.start();
            RedPandaEntity.this.clearStates();
        }

        public boolean canUse() {
            return RedPandaEntity.this.isInWater() && RedPandaEntity.this.getFluidHeight(FluidTags.WATER) > 0.25 || RedPandaEntity.this.isInLava();
        }
    }

    class RedPandaSearchForPlayerItemsGoal
    extends Goal {
        public RedPandaSearchForPlayerItemsGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            List list = RedPandaEntity.this.level().getEntitiesOfClass(Player.class, RedPandaEntity.this.getBoundingBox().inflate(16.0, 16.0, 16.0));
            if (!list.isEmpty()) {
                for (Player player : list) {
                    ItemStack itemStack = player.getItemBySlot(EquipmentSlot.MAINHAND);
                    if (!(itemStack.getItem() instanceof SwordItem)) {
                        RedPandaEntity.this.setScared(false);
                        return false;
                    }
                    if (!(itemStack.getItem() instanceof SwordItem)) continue;
                    RedPandaEntity.this.setScared(true);
                    RedPandaEntity.this.getNavigation().stop();
                    RedPandaEntity.this.lookControl.setLookAt(player.getX(), player.getEyeY(), player.getZ());
                }
            }
            return false;
        }

        public void tick() {
            List list = RedPandaEntity.this.level().getEntitiesOfClass(Player.class, RedPandaEntity.this.getBoundingBox().inflate(16.0, 16.0, 16.0));
            if (!list.isEmpty()) {
                for (Player player : list) {
                    if (player.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                        RedPandaEntity.this.setScared(false);
                        continue;
                    }
                    ItemStack itemStack = player.getItemBySlot(EquipmentSlot.MAINHAND);
                    if (!(itemStack.getItem() instanceof SwordItem)) continue;
                    RedPandaEntity.this.setScared(true);
                    RedPandaEntity.this.getNavigation().stop();
                    RedPandaEntity.this.lookControl.setLookAt(player.getX(), player.getEyeY(), player.getZ());
                }
            }
        }

        public void start() {
            List list = RedPandaEntity.this.level().getEntitiesOfClass(Player.class, RedPandaEntity.this.getBoundingBox().inflate(16.0, 16.0, 16.0));
            if (!list.isEmpty()) {
                for (Player player : list) {
                    if (player.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                        RedPandaEntity.this.setScared(false);
                        continue;
                    }
                    ItemStack itemStack = player.getItemBySlot(EquipmentSlot.MAINHAND);
                    if (!(itemStack.getItem() instanceof SwordItem)) continue;
                    RedPandaEntity.this.setScared(true);
                    RedPandaEntity.this.getNavigation().stop();
                    RedPandaEntity.this.lookControl.setLookAt(player.getX(), player.getEyeY(), player.getZ());
                }
            }
        }
    }

    class RedPandaEntityPanicGoal
    extends PanicGoal {
        public RedPandaEntityPanicGoal(RedPandaEntity this$0, double p_28734_) {
            super((PathfinderMob)this$0, p_28734_);
        }

        public boolean shouldPanic() {
            return super.shouldPanic();
        }
    }

    class SeekShelterGoal
    extends FleeSunGoal {
        private int interval;

        public SeekShelterGoal(double p_28777_) {
            super((PathfinderMob)RedPandaEntity.this, p_28777_);
            this.interval = SeekShelterGoal.reducedTickDelay((int)100);
        }

        public boolean canUse() {
            if (!RedPandaEntity.this.isSleeping() && !RedPandaEntity.this.isScared() && this.mob.getTarget() == null) {
                if (RedPandaEntity.this.level().isThundering()) {
                    return true;
                }
                if (this.interval > 0) {
                    --this.interval;
                    return false;
                }
                this.interval = 100;
                BlockPos blockpos = this.mob.blockPosition();
                return RedPandaEntity.this.level().isDay() && RedPandaEntity.this.level().canSeeSky(blockpos) && !((ServerLevel)RedPandaEntity.this.level()).isVillage(blockpos) && this.setWantedPos();
            }
            return false;
        }

        public void start() {
            RedPandaEntity.this.clearStates();
            super.start();
        }
    }

    class SleepGoal
    extends RedPandaEntityBehaviorGoal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.reducedTickDelay((int)140);
        private int countdown;

        public SleepGoal() {
            this.countdown = RedPandaEntity.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (RedPandaEntity.this.xxa == 0.0f && RedPandaEntity.this.yya == 0.0f && RedPandaEntity.this.zza == 0.0f) {
                return this.canSleep() || RedPandaEntity.this.isSleeping() && !RedPandaEntity.this.isScared();
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return RedPandaEntity.this.level().isDay() && this.hasShelter() && !this.alertable();
        }

        public void stop() {
            this.countdown = RedPandaEntity.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            RedPandaEntity.this.clearStates();
        }

        public void start() {
            RedPandaEntity.this.setSleeping(true);
            RedPandaEntity.this.getNavigation().stop();
            RedPandaEntity.this.getMoveControl().setWantedPosition(RedPandaEntity.this.getX(), RedPandaEntity.this.getY(), RedPandaEntity.this.getZ(), 0.0);
        }
    }

    class RedPandaEntityFollowParentGoal
    extends FollowParentGoal {
        private final RedPandaEntity RedPandaEntity;

        public RedPandaEntityFollowParentGoal(RedPandaEntity this$0, RedPandaEntity p_28696_, double p_28697_) {
            super((Animal)p_28696_, p_28697_);
            this.RedPandaEntity = p_28696_;
        }

        public boolean canUse() {
            return super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse();
        }

        public void start() {
            this.RedPandaEntity.clearStates();
            super.start();
        }
    }

    public class RedPandaEntityEatBambooGoal
    extends MoveToBlockGoal {
        protected int ticksWaited;

        public RedPandaEntityEatBambooGoal(double p_28675_, int p_28676_, int p_28677_) {
            super((PathfinderMob)RedPandaEntity.this, p_28675_, p_28676_, p_28677_);
        }

        public double acceptedDistance() {
            return 2.0;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 100 == 0;
        }

        protected boolean isValidTarget(LevelReader p_28680_, @NotNull BlockPos p_28681_) {
            BlockState blockstate = p_28680_.getBlockState(p_28681_);
            return blockstate.is(Blocks.BAMBOO);
        }

        public void tick() {
            if (this.isReachedTarget()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.isReachedTarget() && RedPandaEntity.this.random.nextFloat() < 0.05f) {
                RedPandaEntity.this.playSound(ModSound.RED_PANDA_SNIFF.get(), 1.0f, 1.0f);
            }
            super.tick();
        }

        protected void onReachedTarget() {
            BlockState blockstate;
            if (RedPandaEntity.this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && (blockstate = RedPandaEntity.this.level().getBlockState(this.blockPos)).is(Blocks.BAMBOO)) {
                this.pickBreakBamboo(blockstate);
            }
        }

        private void pickBreakBamboo(BlockState p_148929_) {
            RedPandaEntity.this.playSound(SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
            RedPandaEntity.this.level().destroyBlock(this.blockPos, true);
        }

        public boolean canUse() {
            return !RedPandaEntity.this.isSleeping() && !RedPandaEntity.this.isScared() && super.canUse();
        }

        public void start() {
            this.ticksWaited = 0;
            super.start();
        }
    }

    class RedPandaEntityLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public RedPandaEntityLookAtPlayerGoal(RedPandaEntity this$0, Mob p_28707_, Class<? extends LivingEntity> p_28708_, float p_28709_) {
            super(p_28707_, p_28708_, p_28709_);
        }

        public boolean canUse() {
            return super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse();
        }
    }

    class PerchAndSearchGoal
    extends RedPandaEntityBehaviorGoal {
        private double relX;
        private double relZ;
        private int lookTime;
        private int looksRemaining;

        public PerchAndSearchGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return RedPandaEntity.this.getLastHurtByMob() == null && RedPandaEntity.this.getRandom().nextFloat() < 0.02f && !RedPandaEntity.this.isSleeping() && !RedPandaEntity.this.isScared() && RedPandaEntity.this.getTarget() == null && RedPandaEntity.this.getNavigation().isDone() && !this.alertable() && !RedPandaEntity.this.isCrouching();
        }

        public boolean canContinueToUse() {
            return this.looksRemaining > 0;
        }

        public void start() {
            this.resetLook();
            this.looksRemaining = 2 + RedPandaEntity.this.getRandom().nextInt(3);
            RedPandaEntity.this.getNavigation().stop();
        }

        public void stop() {
        }

        public void tick() {
            --this.lookTime;
            if (this.lookTime <= 0) {
                --this.looksRemaining;
                this.resetLook();
            }
            RedPandaEntity.this.getLookControl().setLookAt(RedPandaEntity.this.getX() + this.relX, RedPandaEntity.this.getEyeY(), RedPandaEntity.this.getZ() + this.relZ, (float)RedPandaEntity.this.getMaxHeadYRot(), (float)RedPandaEntity.this.getMaxHeadXRot());
        }

        private void resetLook() {
            double d0 = Math.PI * 2 * RedPandaEntity.this.getRandom().nextDouble();
            this.relX = Math.cos(d0);
            this.relZ = Math.sin(d0);
            this.lookTime = this.adjustedTickDelay(80 + RedPandaEntity.this.getRandom().nextInt(20));
        }
    }

    class FoxSearchForItemsGoal
    extends Goal {
        public FoxSearchForItemsGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!RedPandaEntity.this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                return false;
            }
            if (RedPandaEntity.this.getTarget() == null && RedPandaEntity.this.getLastHurtByMob() == null) {
                if (!RedPandaEntity.this.canMove()) {
                    return false;
                }
                if (RedPandaEntity.this.getRandom().nextInt(FoxSearchForItemsGoal.reducedTickDelay((int)10)) != 0) {
                    return false;
                }
                List list = RedPandaEntity.this.level().getEntitiesOfClass(ItemEntity.class, RedPandaEntity.this.getBoundingBox().inflate(16.0, 16.0, 16.0), ALLOWED_ITEMS);
                return !list.isEmpty() && RedPandaEntity.this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
            }
            return false;
        }

        public void tick() {
            List list = RedPandaEntity.this.level().getEntitiesOfClass(ItemEntity.class, RedPandaEntity.this.getBoundingBox().inflate(16.0, 16.0, 16.0), ALLOWED_ITEMS);
            ItemStack itemstack = RedPandaEntity.this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (itemstack.isEmpty() && !list.isEmpty()) {
                RedPandaEntity.this.getNavigation().moveTo((Entity)list.get(0), (double)1.2f);
            }
        }

        public void start() {
            List list = RedPandaEntity.this.level().getEntitiesOfClass(ItemEntity.class, RedPandaEntity.this.getBoundingBox().inflate(16.0, 16.0, 16.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                RedPandaEntity.this.getNavigation().moveTo((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    abstract class RedPandaEntityBehaviorGoal
    extends Goal {
        private final TargetingConditions alertableTargeting;

        RedPandaEntityBehaviorGoal() {
            this.alertableTargeting = TargetingConditions.forCombat().range(12.0).ignoreLineOfSight().selector((Predicate)new RedPandaEntityAlertableEntitiesSelector());
        }

        protected boolean hasShelter() {
            BlockPos blockpos = new BlockPos((int)RedPandaEntity.this.getX(), (int)RedPandaEntity.this.getBoundingBox().maxY, (int)RedPandaEntity.this.getZ());
            return !RedPandaEntity.this.level().canSeeSky(blockpos) && RedPandaEntity.this.getWalkTargetValue(blockpos) >= 0.0f;
        }

        protected boolean alertable() {
            return !RedPandaEntity.this.level().getNearbyEntities(LivingEntity.class, this.alertableTargeting, (LivingEntity)RedPandaEntity.this, RedPandaEntity.this.getBoundingBox().inflate(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class RedPandaEntityAlertableEntitiesSelector
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_28653_) {
            if (p_28653_ instanceof RedPandaEntity) {
                return false;
            }
            if (!(p_28653_ instanceof Monster)) {
                if (p_28653_ instanceof TamableAnimal) {
                    return !((TamableAnimal)p_28653_).isTame();
                }
                if (!(p_28653_ instanceof Player) || !p_28653_.isSpectator() && !((Player)p_28653_).isCreative()) {
                    if (RedPandaEntity.this.getOwnerUUID() != p_28653_.getUUID()) {
                        return false;
                    }
                    return !p_28653_.isSleeping() && !p_28653_.isDiscrete();
                }
                return false;
            }
            return true;
        }
    }
}

