/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.red_panda.client.model;

import com.cozary.red_panda.entity.RedPandaEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class RedPandaModel<T extends RedPandaEntity>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart sleep;
    private final ModelPart frontLeg_R;
    private final ModelPart frontLeg_L;
    private final ModelPart backLeg_R;
    private final ModelPart backLeg_L;
    private final ModelPart tail;
    private final ModelPart shoulder;

    public RedPandaModel(ModelPart root) {
        super(true, 8.0f, 3.35f);
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.sleep = root.getChild("sleep");
        this.frontLeg_R = root.getChild("frontLeg_R");
        this.frontLeg_L = root.getChild("frontLeg_L");
        this.backLeg_R = root.getChild("backLeg_R");
        this.backLeg_L = root.getChild("backLeg_L");
        this.tail = root.getChild("tail");
        this.shoulder = root.getChild("shoulder");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -5.0f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 15).addBox(-4.0f, -2.0f, -6.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(30, 13).addBox(-2.0f, 1.0f, -8.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(2.0f, -4.0f, -3.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -4.0f, -3.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)-5.0f));
        PartDefinition sleep = partdefinition.addOrReplaceChild("sleep", CubeListBuilder.create().texOffs(0, 40).addBox(-4.0f, -12.0f, -11.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(30, 13).addBox(-2.0f, -9.0f, -13.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(2.0f, -14.0f, -8.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -14.0f, -8.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition frontLeg_R = partdefinition.addOrReplaceChild("frontLeg_R", CubeListBuilder.create().texOffs(0, 27).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)19.0f, (float)-3.0f));
        PartDefinition frontLeg_L = partdefinition.addOrReplaceChild("frontLeg_L", CubeListBuilder.create().texOffs(32, 5).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)19.0f, (float)-3.0f));
        PartDefinition backLeg_R = partdefinition.addOrReplaceChild("backLeg_R", CubeListBuilder.create().texOffs(22, 0).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)19.0f, (float)4.0f));
        PartDefinition backLeg_L = partdefinition.addOrReplaceChild("backLeg_L", CubeListBuilder.create().texOffs(9, 32).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)19.0f, (float)4.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(20, 19).addBox(-2.5f, -1.0f, 0.0f, 5.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)5.0f));
        PartDefinition shoulder = partdefinition.addOrReplaceChild("shoulder", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition tail2 = shoulder.addOrReplaceChild("tail2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-10.0f, (float)5.0f));
        PartDefinition cube_r1 = tail2.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(20, 19).addBox(-2.5f, -3.3733f, 0.5245f, 5.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-2.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition backLeg_L2 = shoulder.addOrReplaceChild("backLeg_L2", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-5.0f, (float)4.0f));
        PartDefinition cube_r2 = backLeg_L2.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(9, 32).addBox(-1.5f, -0.1195f, -1.0086f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition backLeg_R2 = shoulder.addOrReplaceChild("backLeg_R2", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)-5.0f, (float)4.0f));
        PartDefinition cube_r3 = backLeg_R2.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(22, 0).addBox(-1.5f, -0.1391f, -1.122f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition frontLeg_L2 = shoulder.addOrReplaceChild("frontLeg_L2", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-10.0f, (float)-3.0f));
        PartDefinition cube_r4 = frontLeg_L2.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(32, 5).addBox(-1.5f, -1.0f, -2.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition frontLeg_R2 = shoulder.addOrReplaceChild("frontLeg_R2", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)-5.0f, (float)-3.0f));
        PartDefinition cube_r5 = frontLeg_R2.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 27).addBox(-1.5f, -4.0f, 4.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head2 = shoulder.addOrReplaceChild("head2", CubeListBuilder.create().texOffs(0, 15).addBox(-4.0f, -2.0f, -6.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(30, 13).addBox(-2.0f, 1.0f, -8.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(2.0f, -4.0f, -3.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -4.0f, -3.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-16.0f, (float)-1.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = shoulder.addOrReplaceChild("body2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition cube_r6 = body2.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -5.0f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.4399f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private static State getState(RedPandaEntity p_103210_) {
        return null;
    }

    public void prepareMobModel(T entity, float p_102665_, float p_102666_, float p_102667_) {
        boolean scared;
        this.shoulder.visible = false;
        this.backLeg_R.visible = true;
        this.backLeg_L.visible = true;
        this.frontLeg_R.visible = true;
        this.frontLeg_L.visible = true;
        this.tail.yRot = 0.0f;
        this.tail.y = 15.0f;
        this.head.y = 15.0f;
        this.head.z = -4.0f;
        this.body.y = 17.0f;
        this.body.z = 0.0f;
        this.sleep.visible = false;
        this.head.visible = true;
        this.body.xRot = 0.0f;
        this.frontLeg_R.xRot = 0.0f;
        this.frontLeg_L.xRot = 0.0f;
        this.frontLeg_R.yRot = 0.0f;
        this.frontLeg_L.yRot = 0.0f;
        this.frontLeg_R.zRot = 0.0f;
        this.frontLeg_L.zRot = 0.0f;
        this.backLeg_R.zRot = 0.0f;
        this.backLeg_L.zRot = 0.0f;
        this.frontLeg_R.y = 19.0f;
        this.frontLeg_L.y = 19.0f;
        this.frontLeg_R.z = -3.0f;
        this.frontLeg_L.z = -3.0f;
        this.frontLeg_R.x = -2.0f;
        this.frontLeg_L.x = 2.0f;
        this.backLeg_R.z = 5.0f;
        this.backLeg_L.z = 5.0f;
        boolean sleep = ((RedPandaEntity)((Object)entity)).isSleeping();
        if (sleep) {
            this.head.visible = false;
            this.sleep.visible = true;
            this.sleep.y = 30.0f;
            this.backLeg_R.visible = false;
            this.backLeg_L.visible = false;
            this.frontLeg_R.visible = false;
            this.frontLeg_L.visible = false;
            this.tail.y = 20.0f;
            this.tail.yRot = 90.0f;
            this.body.y = 22.0f;
        }
        if (scared = ((RedPandaEntity)((Object)entity)).isScared()) {
            this.body.xRot = 30.0f;
            this.body.y = 15.0f;
            this.body.z = 2.0f;
            this.frontLeg_R.y = 12.0f;
            this.frontLeg_L.y = 12.0f;
            this.frontLeg_R.z = 2.0f;
            this.frontLeg_L.z = 2.0f;
            this.frontLeg_R.x = -3.0f;
            this.frontLeg_L.x = 3.0f;
            this.frontLeg_R.yRot = 45.0f;
            this.frontLeg_L.yRot = -45.0f;
            this.head.y = 7.0f;
            this.head.z = 3.0f;
            this.backLeg_R.z = 2.0f;
            this.backLeg_L.z = 2.0f;
        }
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean scared;
        this.setupAnim(RedPandaModel.getState(entity), ((RedPandaEntity)((Object)entity)).tickCount, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.shoulder.visible = false;
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.backLeg_R.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.backLeg_L.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.frontLeg_R.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.frontLeg_L.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.tail.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.6f * limbSwingAmount;
        boolean sleep = ((RedPandaEntity)((Object)entity)).isSleeping();
        if (sleep) {
            this.head.xRot = 0.0f;
            this.head.yRot = 0.0f;
        }
        if (scared = ((RedPandaEntity)((Object)entity)).isScared()) {
            this.frontLeg_R.xRot = 30.0f;
            this.frontLeg_L.xRot = 30.0f;
            this.frontLeg_R.zRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.frontLeg_L.zRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 0.25f;
        }
    }

    private void setupAnim(State state, int tickCount, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (state == State.ON_SHOULDER) {
            this.shoulder.visible = true;
            this.shoulder.y = 34.0f;
            this.shoulder.z = 5.0f;
            this.shoulder.getChild((String)"tail2").xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.3f * limbSwingAmount;
            this.shoulder.getChild((String)"backLeg_R2").xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.2f * limbSwingAmount;
            this.shoulder.getChild((String)"backLeg_L2").xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.2f * limbSwingAmount;
        }
    }

    public void renderOnShoulder(PoseStack poseStack, VertexConsumer p_103225_, int p_103226_, int p_103227_, float p_103228_, float p_103229_, float p_103230_, float p_103231_, int p_103232_) {
        this.setupAnim(State.ON_SHOULDER, p_103232_, p_103228_, p_103229_, 0.0f, p_103230_, p_103231_);
        this.shoulder.render(poseStack, p_103225_, p_103226_, p_103227_);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
        if (!this.young) {
            this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.sleep.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.frontLeg_R.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.frontLeg_L.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.backLeg_R.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.backLeg_L.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.tail.render(poseStack, buffer, packedLight, packedOverlay, color);
            this.shoulder.render(poseStack, buffer, packedLight, packedOverlay, color);
        }
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head, (Object)this.sleep);
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.backLeg_L, (Object)this.backLeg_R, (Object)this.frontLeg_L, (Object)this.frontLeg_R, (Object)this.tail);
    }

    public static enum State {
        ON_SHOULDER;

    }
}

