/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum.entity;

import com.startraveler.bearminimum.Constants;
import com.startraveler.bearminimum.entity.AbstractBearEntity;
import com.startraveler.bearminimum.entity.BearFoodPreferences;
import com.startraveler.bearminimum.entity.goal.AbstractBearAttackPlayersGoal;
import com.startraveler.bearminimum.entity.goal.AbstractBearHurtByTargetGoal;
import com.startraveler.bearminimum.entity.goal.AbstractBearMeleeAttackGoal;
import com.startraveler.bearminimum.entity.goal.ForageGoal;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BlackBearEntity
extends AbstractBearEntity {
    public static final TagKey<Biome> HAS_BLACK_BEAR_SPAWNS = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Constants.id("has_black_bear_spawns"));
    public static final BearFoodPreferences BLACK_BEAR_FOODS = new BearFoodPreferences(BearFoodPreferences.BLACK_BEAR_FOOD, BearFoodPreferences.BLACK_BEAR_PREY, BearFoodPreferences.BLACK_BEAR_FORAGE);

    public BlackBearEntity(EntityType<? extends BlackBearEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.SCALE, 0.8);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)this.getType().create((Level)level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AbstractBearMeleeAttackGoal(this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5, bear -> bear.isBaby() ? DamageTypeTags.PANIC_CAUSES : DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, entity -> entity.isUsingItem() && entity.getUseItem().getItem() instanceof InstrumentItem, 16.0f, 2.25, 2.25, entity -> true));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 0.6666666865348816));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 0.5, stack -> stack.is(this.getFoodPreferences().foodTag()), true));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, entity -> !this.isAngry(), 4.0f, 1.5, 1.5, EntitySelector.NO_CREATIVE_OR_SPECTATOR::test));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Villager.class, entity -> !this.isAngry(), 4.0f, 1.5, 1.5, EntitySelector.NO_CREATIVE_OR_SPECTATOR::test));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new ForageGoal(this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AbstractBearHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new AbstractBearAttackPlayersGoal(this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((BlackBearEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, true, entity -> this.wantsMoreFood() && entity.getType().is(this.getFoodPreferences().preyTag())));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    public BearFoodPreferences getFoodPreferences() {
        return BLACK_BEAR_FOODS;
    }
}

