/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import dev.tr7zw.waveycapes.util.NMSHelper;
import dev.tr7zw.waveycapes.versionless.CapeHolder;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Items;

public class CapeRenderInfo {
    private final AbstractClientPlayer player;

    public AbstractClientPlayer getPlayer() {
        return this.player;
    }

    public CapeRenderInfo(AbstractClientPlayer player) {
        this.player = player;
    }

    public boolean isPlayerUnderwater() {
        return this.player.isUnderWater();
    }

    public ResourceLocation getCapeTexture() {
        return NMSHelper.getPlayerCape(this.player);
    }

    public CapeHolder getCapeHolder() {
        return (CapeHolder)this.player;
    }

    public boolean isPlayerInvisible() {
        return this.player.isInvisible();
    }

    public boolean isCapeVisible() {
        return this.player.isModelPartShown(PlayerModelPart.CAPE);
    }

    public boolean hasElytraEquipped() {
        return this.player.getItemBySlot(EquipmentSlot.CHEST).getItem().equals(Items.ELYTRA);
    }

    public boolean hasChestplateEquipped() {
        return !this.hasElytraEquipped() && !this.player.getItemBySlot(EquipmentSlot.CHEST).isEmpty();
    }
}

