/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.untitledduckmod.common.config.UntitledConfig;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import net.untitledduckmod.common.entity.ai.goal.common.EatGoal;
import net.untitledduckmod.common.entity.ai.goal.common.FollowParentGoal;
import net.untitledduckmod.common.entity.ai.goal.common.SwimGoal;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModItems;
import net.untitledduckmod.common.init.ModSoundEvents;
import net.untitledduckmod.common.init.ModTags;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DuckEntity
extends WaterfowlEntity
implements VibrationSystem,
AnimationController.ParticleKeyframeHandler<DuckEntity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String IS_FROM_SACK_TAG = "isFromSack";
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.defineId(DuckEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final byte ANIMATION_DIVE = 2;
    private static final RawAnimation SWIM_CLEAN_ANIM = RawAnimation.begin().thenPlay("clean_swim").thenPlay("idle_swim");
    private static final RawAnimation DIVE_ANIM = RawAnimation.begin().thenPlay("dive").thenPlay("idle_swim");
    private static final RawAnimation DANCE_ANIM = RawAnimation.begin().thenPlay("dance");
    public static final Ingredient BREEDING_INGREDIENT = Ingredient.of(ModTags.ItemTags.DUCK_BREEDING_FOOD);
    public static final Ingredient TAMING_INGREDIENT = Ingredient.of(ModTags.ItemTags.DUCK_TAMING_FOOD);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isFromSack = false;
    @Nullable
    private BlockPos jukeboxPos;
    private VibrationSystem.Data vibrationListenerData;
    private final VibrationSystem.User vibrationCallback = new VibrationCallback();
    private final DynamicGameEventListener<JukeboxEventListener> jukeboxEventHandler;

    public DuckEntity(EntityType<? extends WaterfowlEntity> entityType, Level world) {
        super(entityType, world);
        this.vibrationListenerData = new VibrationSystem.Data();
        this.jukeboxEventHandler = new DynamicGameEventListener((GameEventListener)new JukeboxEventListener(this.vibrationCallback.getPositionSource(), ((GameEvent)GameEvent.JUKEBOX_PLAY.value()).notificationRadius()));
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 7.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.LUCK);
    }

    @Override
    public void setTame(boolean tamed, boolean updateAttributes) {
        super.setTame(tamed, updateAttributes);
        Objects.requireNonNull(this.getAttribute(Attributes.LUCK)).setBaseValue(2.0);
    }

    public static boolean checkDuckSpawnRules(EntityType<DuckEntity> duck, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModTags.BlockTags.DUCKS_SPAWNABLE_ON) || world.getBlockState(pos.below()).getFluidState().is(FluidTags.WATER);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DANCING, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean(IS_FROM_SACK_TAG, this.isFromSack);
        DataResult result = VibrationSystem.Data.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.vibrationListenerData);
        result.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(nbtElement -> tag.put("listener", nbtElement));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setFromSack(tag.getBoolean(IS_FROM_SACK_TAG));
        if (tag.contains("listener", 10)) {
            DataResult result = VibrationSystem.Data.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("listener")));
            result.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(listenerData -> {
                this.vibrationListenerData = listenerData;
            });
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            VibrationSystem.Ticker.tick((Level)this.level(), (VibrationSystem.Data)this.vibrationListenerData, (VibrationSystem.User)this.vibrationCallback);
        }
    }

    public void setRecordPlayingNearby(BlockPos jukeboxPos, boolean playing) {
        if (playing) {
            if (!this.isDancing()) {
                this.jukeboxPos = jukeboxPos;
                this.setDancing(true);
            }
        } else if (jukeboxPos.equals((Object)this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDancing(false);
        }
    }

    public boolean isDancing() {
        return (Boolean)this.entityData.get(DANCING);
    }

    public void setDancing(boolean dancing) {
        if (!(this.level().isClientSide || !this.isEffectiveAi() || dancing && this.panicked)) {
            if (dancing) {
                this.setAnimation((byte)3);
            } else {
                this.setAnimation((byte)0);
            }
            this.entityData.set(DANCING, (Object)dancing);
        }
    }

    private boolean shouldStopDancing() {
        return this.jukeboxPos == null || !this.jukeboxPos.closerToCenterThan((Position)this.position(), (double)((GameEvent)GameEvent.JUKEBOX_PLAY.value()).notificationRadius()) || !this.level().getBlockState(this.jukeboxPos).is(Blocks.JUKEBOX) || this.panicked;
    }

    public VibrationSystem.Data getVibrationData() {
        return this.vibrationListenerData;
    }

    public VibrationSystem.User getVibrationUser() {
        return this.vibrationCallback;
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> callback) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            callback.accept(this.jukeboxEventHandler, serverWorld);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SwimGoal(this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new EatGoal(this));
        this.goalSelector.addGoal(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal(this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.6, 10.0f, 2.0f));
        this.goalSelector.addGoal(6, (Goal)new CleanGoal(this));
        this.goalSelector.addGoal(6, (Goal)new DiveGoal(this));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isFood(ItemStack stack) {
        if (this.isTame()) {
            return TAMING_INGREDIENT.test(stack) || BREEDING_INGREDIENT.test(stack);
        }
        return BREEDING_INGREDIENT.test(stack);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.isDancing() && this.shouldStopDancing() && this.tickCount % 20 == 0) {
            this.setDancing(false);
            this.jukeboxPos = null;
        }
    }

    @Override
    protected void handlePanicAnimation() {
        if (!this.panicked && this.getLastHurtByMob() != null || this.isOnFire()) {
            this.setAnimation((byte)4);
            this.panicked = true;
        } else if (this.panicked && this.getLastHurtByMob() == null && !this.isOnFire()) {
            this.setAnimation((byte)0);
            this.panicked = false;
        }
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (stackInHand.getItem() == ModItems.EMPTY_DUCK_SACK.get()) {
            CompoundTag duckData = new CompoundTag();
            if (this.saveAsPassenger(duckData)) {
                stackInHand.consume(1, (LivingEntity)player);
                ItemStack duckSack = new ItemStack((ItemLike)ModItems.DUCK_SACK.get());
                duckSack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)duckData));
                if (stackInHand.isEmpty()) {
                    player.setItemInHand(hand, duckSack);
                } else if (!player.addItem(duckSack)) {
                    player.drop(duckSack, false);
                }
                this.level().playSound(null, this.blockPosition(), ModSoundEvents.DUCK_SACK_USE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                LOGGER.error("Could not save duck data to duck sack!");
            }
            this.discard();
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    @Override
    protected boolean isTamableItem(ItemStack stack) {
        return TAMING_INGREDIENT.test(stack);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        DuckEntity duckEntity = (DuckEntity)ModEntityTypes.getDuck().create((Level)world);
        if (duckEntity != null && entity instanceof DuckEntity) {
            DuckEntity duck = (DuckEntity)entity;
            if (this.random.nextBoolean()) {
                duckEntity.setVariant(this.getVariant());
            } else {
                duckEntity.setVariant(duck.getVariant());
            }
            if (this.isTame()) {
                duckEntity.setOwnerUUID(this.getOwnerUUID());
                duckEntity.setTame(true, true);
            }
        }
        return duckEntity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate);
        controller.setParticleKeyframeHandler((AnimationController.ParticleKeyframeHandler)this);
        controllerRegistrar.add(controller);
    }

    @Override
    protected SoundEvent getLayEggSound() {
        return ModSoundEvents.DUCK_LAY_EGG.get();
    }

    @Override
    public Item getEggItem() {
        return ModItems.DUCK_EGG.get();
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.isInWater();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.isInSittingPose()) {
            controller.setAnimation(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 1: {
                controller.setAnimation(inWater ? SWIM_CLEAN_ANIM : CLEAN_ANIM);
                break;
            }
            case 2: {
                controller.setAnimation(DIVE_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(DANCE_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            case 5: {
                controller.setAnimation(EAT_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void playAmbientSound() {
        if (this.isBaby()) {
            this.playSound(ModSoundEvents.DUCKLING_AMBIENT.get(), 0.3f, this.getVoicePitch());
            return;
        }
        this.playSound(ModSoundEvents.DUCK_AMBIENT.get(), 0.1f, this.getVoicePitch());
    }

    protected void playHurtSound(DamageSource source) {
        if (this.isBaby()) {
            this.playSound(ModSoundEvents.DUCKLING_HURT.get(), 0.3f, this.getVoicePitch() + 0.25f);
            return;
        }
        this.playSound(ModSoundEvents.DUCK_HURT.get(), 0.1f, this.getVoicePitch() + 0.5f);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        if (this.isBaby()) {
            return ModSoundEvents.DUCKLING_DEATH.get();
        }
        return ModSoundEvents.DUCK_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(ModSoundEvents.DUCK_STEP.get(), 0.15f, 1.0f);
    }

    public void handle(ParticleKeyframeEvent particleKeyframeEvent) {
        ItemStack stack = this.getMainHandItem();
        if (stack == ItemStack.EMPTY) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Vec3 vel = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vel = vel.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vel = vel.yRot(-this.getYRot() * ((float)Math.PI / 180));
            Vec3 rotationVec = Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot);
            Vec3 pos = new Vec3(this.getX() + rotationVec.x / 2.0, this.getEyeY() - 0.2, this.getZ() + rotationVec.z / 2.0);
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x, pos.y, pos.z, vel.x, vel.y + 0.05, vel.z);
        }
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.isFromSack;
    }

    public boolean isFromSack() {
        return this.isFromSack;
    }

    public void setFromSack(boolean fromSack) {
        this.isFromSack = fromSack;
    }

    public ItemStack equipItemIfPossible(ItemStack equipment) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        ItemStack itemStack = this.getMainHandItem();
        if (this.canHoldItem(equipment)) {
            ItemEntity itemEntity;
            if (!itemStack.isEmpty() && (itemEntity = this.spawnAtLocation(itemStack)) != null) {
                itemEntity.setPickUpDelay(40);
            }
            this.setItemSlotAndDropWhenKilled(equipmentSlot, equipment);
            return equipment;
        }
        return ItemStack.EMPTY;
    }

    protected void pickUpItem(ItemEntity item) {
        if (this.isTame() && !this.getMainHandItem().isEmpty() && item.getOwner() != null && !item.getOwner().getUUID().equals(this.getOwnerUUID())) {
            return;
        }
        super.pickUpItem(item);
    }

    public boolean canHoldItem(ItemStack stack) {
        ItemStack mainHandStack = this.getMainHandItem();
        if (mainHandStack.isEmpty()) {
            return this.isFood(stack) || this.isTamableItem(stack);
        }
        if (this.isTame() && !mainHandStack.isEmpty()) {
            return this.isFood(stack);
        }
        return this.isTamableItem(mainHandStack) && this.isFood(stack);
    }

    public boolean canPickUpLoot() {
        if (this.isBaby()) {
            return false;
        }
        return !this.getMainHandItem().isEmpty() || this.isHungry();
    }

    public void fishing() {
        MinecraftServer server = this.level().getServer();
        if (!this.level().isClientSide && server != null) {
            LootParams lootBuilder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)Items.FISHING_ROD.getDefaultInstance()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withLuck((float)this.getAttributeValue(Attributes.LUCK)).create(LootContextParamSets.FISHING);
            LootTable lootTable = server.reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
            ObjectArrayList list = lootTable.getRandomItems(lootBuilder);
            for (ItemStack stack : list) {
                if (!this.isTame() && !this.isTamableItem(stack)) continue;
                this.setItemInHand(InteractionHand.MAIN_HAND, stack);
                this.setItemSlotAndDropWhenKilled(EquipmentSlot.MAINHAND, stack);
                break;
            }
        }
    }

    private class VibrationCallback
    implements VibrationSystem.User {
        private final PositionSource positionSource;

        private VibrationCallback() {
            this.positionSource = new EntityPositionSource((Entity)DuckEntity.this, DuckEntity.this.getEyeHeight());
        }

        public int getListenerRadius() {
            return 10;
        }

        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public boolean canReceiveVibration(ServerLevel world, BlockPos pos, Holder<GameEvent> event, GameEvent.Context emitter) {
            return !DuckEntity.this.isNoAi();
        }

        public void onReceiveVibration(ServerLevel world, BlockPos pos, Holder<GameEvent> event, @Nullable Entity sourceEntity, @Nullable Entity entity, float distance) {
        }
    }

    private class JukeboxEventListener
    implements GameEventListener {
        private final PositionSource positionSource;
        private final int range;

        public JukeboxEventListener(PositionSource positionSource, int range) {
            this.positionSource = positionSource;
            this.range = range;
        }

        public PositionSource getListenerSource() {
            return this.positionSource;
        }

        public int getListenerRadius() {
            return this.range;
        }

        public boolean handleGameEvent(ServerLevel world, Holder<GameEvent> event, GameEvent.Context emitter, Vec3 emitterPos) {
            if (event == GameEvent.JUKEBOX_PLAY) {
                DuckEntity.this.setRecordPlayingNearby(BlockPos.containing((Position)emitterPos), true);
                return true;
            }
            if (event == GameEvent.JUKEBOX_STOP_PLAY) {
                DuckEntity.this.setRecordPlayingNearby(BlockPos.containing((Position)emitterPos), false);
                return true;
            }
            return false;
        }
    }

    static class CleanGoal
    extends Goal {
        private static final int ANIMATION_LENGTH = 32;
        private final DuckEntity duck;
        private int cleanTime;
        private int nextCleanTime;

        public CleanGoal(DuckEntity duck) {
            this.duck = duck;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nextCleanTime = duck.tickCount + (200 + duck.getRandom().nextInt(10) * 20);
        }

        public boolean canUse() {
            if (this.nextCleanTime > this.duck.tickCount || this.duck.getNoActionTime() >= 100 || this.duck.getAnimation() != 0) {
                return false;
            }
            return this.duck.getRandom().nextInt(40) == 0;
        }

        public void start() {
            this.cleanTime = 32;
            this.duck.setAnimation((byte)1);
            this.nextCleanTime = this.duck.tickCount + (200 + this.duck.getRandom().nextInt(10) * 20);
        }

        public void stop() {
            this.duck.setAnimation((byte)0);
        }

        public boolean canContinueToUse() {
            return this.cleanTime >= 0;
        }

        public void tick() {
            --this.cleanTime;
        }
    }

    static class DiveGoal
    extends Goal {
        private static final int ANIMATION_LENGTH = 32;
        private final DuckEntity duck;
        private int diveTime;
        private int nextDiveTime;

        public DiveGoal(DuckEntity duck) {
            this.duck = duck;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nextDiveTime = duck.tickCount + (160 + duck.getRandom().nextInt(10) * 20);
        }

        public boolean canUse() {
            if (this.nextDiveTime > this.duck.tickCount || this.duck.getNoActionTime() >= 100 || !this.duck.isInWater() || this.duck.getAnimation() != 0) {
                return false;
            }
            return this.duck.getRandom().nextInt(40) == 0 && this.duck.getMainHandItem().isEmpty();
        }

        public void start() {
            this.diveTime = 32;
            this.duck.setAnimation((byte)2);
            this.nextDiveTime = this.duck.tickCount + (160 + this.duck.getRandom().nextInt(10) * 20);
        }

        public void stop() {
            this.duck.setAnimation((byte)0);
        }

        public boolean canContinueToUse() {
            return this.diveTime >= 0;
        }

        public void tick() {
            --this.diveTime;
            if (this.diveTime == 22) {
                if (this.duck.getRandom().nextDouble() < UntitledConfig.duckFishingChange()) {
                    this.duck.fishing();
                }
                this.duck.playSound(SoundEvents.GENERIC_SPLASH, 1.0f, 1.0f);
            }
        }
    }
}

