/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register.client;

import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import dev.lopyluna.dndecor.DnDecor;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SpriteShifter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class DnDecorSpriteShifts {
    public static final Map<DyeColor, SpriteShiftEntry> DYED_BELTS = new EnumMap<DyeColor, SpriteShiftEntry>(DyeColor.class);
    public static final Map<DyeColor, SpriteShiftEntry> DYED_OFFSET_BELTS = new EnumMap<DyeColor, SpriteShiftEntry>(DyeColor.class);
    public static final Map<DyeColor, SpriteShiftEntry> DYED_DIAGONAL_BELTS = new EnumMap<DyeColor, SpriteShiftEntry>(DyeColor.class);
    private static final Map<DyeColor, Couple<CTSpriteShiftEntry>> COLORED_STORAGE_TOP = new HashMap<DyeColor, Couple<CTSpriteShiftEntry>>();
    private static final Map<DyeColor, Couple<CTSpriteShiftEntry>> COLORED_STORAGE_FRONT = new HashMap<DyeColor, Couple<CTSpriteShiftEntry>>();
    private static final Map<DyeColor, Couple<CTSpriteShiftEntry>> COLORED_STORAGE_SIDE = new HashMap<DyeColor, Couple<CTSpriteShiftEntry>>();
    private static final Map<DyeColor, Couple<CTSpriteShiftEntry>> COLORED_STORAGE_BOTTOM = new HashMap<DyeColor, Couple<CTSpriteShiftEntry>>();
    public static final SpriteShiftEntry BELT = DnDecorSpriteShifts.get("block/belt", "block/belt_scroll");
    public static final SpriteShiftEntry BELT_OFFSET = DnDecorSpriteShifts.get("block/belt_offset", "block/belt_scroll");
    public static final SpriteShiftEntry BELT_DIAGONAL = DnDecorSpriteShifts.get("block/belt_diagonal", "block/belt_diagonal_scroll");

    private static void populateMaps() {
        for (DyeColor color : DyeColor.values()) {
            String id = color.getSerializedName();
            DYED_BELTS.put(color, DnDecorSpriteShifts.get("block/belt", "block/belt/" + id + "_scroll"));
            DYED_OFFSET_BELTS.put(color, DnDecorSpriteShifts.get("block/belt_offset", "block/belt/" + id + "_scroll"));
            DYED_DIAGONAL_BELTS.put(color, DnDecorSpriteShifts.get("block/belt_diagonal", "block/belt/" + id + "_diagonal_scroll"));
            COLORED_STORAGE_TOP.put(color, DnDecorSpriteShifts.storage("top", color));
            COLORED_STORAGE_FRONT.put(color, DnDecorSpriteShifts.storage("front", color));
            COLORED_STORAGE_SIDE.put(color, DnDecorSpriteShifts.storage("side", color));
            COLORED_STORAGE_BOTTOM.put(color, DnDecorSpriteShifts.storage("bottom", color));
        }
    }

    public static CTSpriteShiftEntry getColoredStorageTop(DyeColor color, boolean small) {
        return (CTSpriteShiftEntry)COLORED_STORAGE_TOP.get(color).get(small);
    }

    public static CTSpriteShiftEntry getColoredStorageFront(DyeColor color, boolean small) {
        return (CTSpriteShiftEntry)COLORED_STORAGE_FRONT.get(color).get(small);
    }

    public static CTSpriteShiftEntry getColoredStorageSide(DyeColor color, boolean small) {
        return (CTSpriteShiftEntry)COLORED_STORAGE_SIDE.get(color).get(small);
    }

    public static CTSpriteShiftEntry getColoredStorageBottom(DyeColor color, boolean small) {
        return (CTSpriteShiftEntry)COLORED_STORAGE_BOTTOM.get(color).get(small);
    }

    private static Couple<CTSpriteShiftEntry> storage(String name, DyeColor color) {
        String prefixed = "block/storage_container/" + color.getSerializedName() + "_storage_container_" + name;
        return Couple.createWithContext(medium -> CTSpriteShifter.getCT((CTType)AllCTTypes.RECTANGLE, (ResourceLocation)DnDecor.loc(prefixed + "_small"), (ResourceLocation)DnDecor.loc(medium != false ? prefixed + "_medium" : prefixed + "_large")));
    }

    private static SpriteShiftEntry get(String originalLocation, String targetLocation) {
        return SpriteShifter.get((ResourceLocation)DnDecor.loc(originalLocation), (ResourceLocation)DnDecor.loc(targetLocation));
    }

    public static void init() {
    }

    static {
        DnDecorSpriteShifts.populateMaps();
    }
}

