/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.integration.jei.category.printing;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.UIRenderHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.client.model.CEIPartialModels;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterRenderer;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;

public class AnimatedPrinter
extends AnimatedKinetics {
    private FluidStack fluid = FluidStack.EMPTY;

    public AnimatedPrinter withFluid(FluidStack fluid) {
        this.fluid = fluid;
        return this;
    }

    public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)xOffset, (float)yOffset, 100.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        poseStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        int scale = 20;
        this.blockElement(CEIBlocks.PRINTER.getDefaultState()).scale((double)scale).render(graphics);
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(this.offset * 8)) % 30.0f;
        float progress = cycle < 20.0f ? -PrinterRenderer.getProgress(cycle / 20.0f * 50.0f) : 0.0f;
        poseStack.pushPose();
        poseStack.translate(0.0f, 3.0f * (progress *= (float)scale) / 32.0f, 0.0f);
        this.blockElement(CEIPartialModels.PRINTER_NOZZLE_TOP).scale((double)scale).render(graphics);
        poseStack.translate(0.0f, 3.0f * progress / 32.0f, 0.0f);
        this.blockElement(CEIPartialModels.PRINTER_NOZZLE_BOTTOM).scale((double)scale).render(graphics);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0f, -progress / 2.0f, 0.0f);
        this.blockElement(CEIPartialModels.PRINTER_PISTON).scale((double)scale).render(graphics);
        poseStack.popPose();
        this.blockElement(AllBlocks.DEPOT.getDefaultState()).atLocal(0.0, 2.0, 0.0).scale((double)scale).render(graphics);
        if (this.fluid.isEmpty()) {
            poseStack.popPose();
            return;
        }
        AnimatedKinetics.DEFAULT_LIGHTING.applyLighting();
        poseStack.pushPose();
        UIRenderHelper.flipForGuiRender((PoseStack)poseStack);
        poseStack.scale(16.0f, 16.0f, 16.0f);
        float from = 0.1875f;
        float to = 1.0625f;
        FluidRenderer.renderFluidBox((Fluid)this.fluid.getFluid(), (long)this.fluid.getAmount(), (float)from, (float)from, (float)from, (float)to, (float)to, (float)to, (MultiBufferSource)graphics.bufferSource(), (PoseStack)poseStack, (int)0xF000F0, (boolean)false, (boolean)true, (DataComponentPatch)this.fluid.getComponentsPatch());
        poseStack.popPose();
        graphics.flush();
        Lighting.setupFor3DItems();
        poseStack.popPose();
    }
}

