/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.kinetics.deployer;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

@EventBusSubscriber
public class DeployerExtension {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (!(player instanceof DeployerFakePlayer)) {
            return;
        }
        DeployerFakePlayer deployer = (DeployerFakePlayer)player;
        int experience = Mth.ceil((float)((float)event.getDroppedExperience() * CEIConfig.kinetics().deployerKillXpScale.getF()));
        event.setDroppedExperience(experience);
        if (((Boolean)CEIConfig.kinetics().deployerCollectXp.get()).booleanValue()) {
            deployer.giveExperiencePoints(experience);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockDrops(BlockDropsEvent event) {
        Entity entity = event.getBreaker();
        if (!(entity instanceof DeployerFakePlayer)) {
            return;
        }
        DeployerFakePlayer deployer = (DeployerFakePlayer)entity;
        boolean dropXp = (Boolean)CEIConfig.kinetics().deployerMineDropXp.get();
        int experience = Mth.ceil((float)((float)event.getDroppedExperience() * CEIConfig.kinetics().deployerMineXpScale.getF()));
        if (((Boolean)CEIConfig.kinetics().deployerCollectXp.get()).booleanValue()) {
            deployer.giveExperiencePoints(experience);
            dropXp = false;
        }
        if (dropXp) {
            event.getState().getBlock().popExperience(event.getLevel(), event.getPos(), experience);
        }
        event.getDrops().stream().map(ItemEntity::getItem).forEach(arg_0 -> ((Inventory)deployer.getInventory()).placeItemBackInInventory(arg_0));
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onXpChange(PlayerXpEvent.XpChange event) {
        int nuggets;
        ItemStack heldItem;
        Player player = event.getEntity();
        if (!(player instanceof DeployerFakePlayer)) {
            return;
        }
        DeployerFakePlayer deployer = (DeployerFakePlayer)player;
        if (!((Boolean)CEIConfig.kinetics().deployerCollectXp.get()).booleanValue()) {
            return;
        }
        int total = deployer.totalExperience + event.getAmount();
        int consumed = 0;
        if (((Boolean)CEIConfig.kinetics().deployerMendItem.get()).booleanValue() && ExperienceHelper.canRepairItem(heldItem = deployer.getMainHandItem())) {
            consumed = ExperienceHelper.repairItem(total, deployer.serverLevel(), heldItem, false);
        }
        if ((nuggets = (event.getAmount() - consumed) / 3) > 0) {
            deployer.getInventory().placeItemBackInInventory(AllItems.EXP_NUGGET.asStack(nuggets));
        }
        event.setAmount(total - consumed - nuggets * 3);
    }
}

