/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour;

import com.mojang.serialization.DataResult;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.AddressPrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.CopyPrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.CustomNamePrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.EnchantedBookPrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.PackagePatternPrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.RecipePrintingBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.printer.behaviour.WrittenBookPrintingBehaviour;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

public interface PrintingBehaviour
extends IHaveGoggleInformation {
    @ApiStatus.Internal
    public static final List<Provider> PROVIDERS = (List)Util.make(new ArrayList(), list -> {
        if (((Boolean)CEIConfig.fluids().enablePackageAddressPrinting.get()).booleanValue()) {
            list.add(AddressPrintingBehaviour::create);
        }
        if (((Boolean)CEIConfig.fluids().enablePackagePatternPrinting.get()).booleanValue()) {
            list.add(PackagePatternPrintingBehaviour::create);
        }
        if (((Boolean)CEIConfig.fluids().enableCreateCopiableItemPrinting.get()).booleanValue()) {
            list.add(CopyPrintingBehaviour::create);
        }
        if (((Boolean)CEIConfig.fluids().enableCustomNamePrinting.get()).booleanValue()) {
            list.add(CustomNamePrintingBehaviour::create);
        }
        if (((Boolean)CEIConfig.fluids().enableEnchantedBookPrinting.get()).booleanValue()) {
            list.add(EnchantedBookPrintingBehaviour::create);
        }
        if (((Boolean)CEIConfig.fluids().enableWrittenBookPrinting.get()).booleanValue()) {
            list.add(WrittenBookPrintingBehaviour::create);
        }
    });

    public static void register(Provider provider) {
        PROVIDERS.add(provider);
    }

    public static DataResult<PrintingBehaviour> create(Level level, SmartFluidTankBehaviour tank, ItemStack stack) {
        for (Provider provider : PROVIDERS) {
            Optional<DataResult<PrintingBehaviour>> result = provider.create(level, tank, stack);
            if (!result.isPresent()) continue;
            return result.get();
        }
        return DataResult.success((Object)new RecipePrintingBehaviour(stack));
    }

    default public boolean isValid() {
        return true;
    }

    default public boolean isSafeNBT() {
        return true;
    }

    public int getRequiredItemCount(Level var1, ItemStack var2);

    public int getRequiredFluidAmount(Level var1, ItemStack var2, FluidStack var3);

    public ItemStack getResult(Level var1, ItemStack var2, FluidStack var3);

    public void onFinished(Level var1, BlockPos var2, PrinterBlockEntity var3);

    @FunctionalInterface
    public static interface Provider {
        public Optional<DataResult<PrintingBehaviour>> create(Level var1, SmartFluidTankBehaviour var2, ItemStack var3);
    }
}

