/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.utils;

import com.simibubi.create.AllBlocks;
import com.tterrag.registrate.util.entry.BlockEntry;
import fr.iglee42.createcasing.registries.ModBlocks;
import java.util.Arrays;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public enum EncasableBlocks {
    ANDESITE((BlockEntry<? extends Block>)AllBlocks.ANDESITE_CASING, (BlockEntry<? extends Block>)AllBlocks.GEARBOX, (BlockEntry<? extends Block>)AllBlocks.MECHANICAL_MIXER, (BlockEntry<? extends Block>)AllBlocks.MECHANICAL_PRESS, (BlockEntry<? extends Block>)AllBlocks.DEPOT, (BlockEntry<? extends Block>)AllBlocks.ENCASED_CHAIN_DRIVE, (BlockEntry<? extends Block>)AllBlocks.ADJUSTABLE_CHAIN_GEARSHIFT, ModBlocks.ANDESITE_CONFIGURABLE_GEARBOX),
    BRASS((BlockEntry<? extends Block>)AllBlocks.BRASS_CASING, ModBlocks.BRASS_GEARBOX, ModBlocks.BRASS_MIXER, ModBlocks.BRASS_PRESS, ModBlocks.BRASS_DEPOT, ModBlocks.BRASS_CHAIN_DRIVE, ModBlocks.BRASS_CHAIN_GEARSHIFT, ModBlocks.BRASS_CONFIGURABLE_GEARBOX),
    COPPER((BlockEntry<? extends Block>)AllBlocks.COPPER_CASING, ModBlocks.COPPER_GEARBOX, ModBlocks.COPPER_MIXER, ModBlocks.COPPER_PRESS, ModBlocks.COPPER_DEPOT, ModBlocks.COPPER_CHAIN_DRIVE, ModBlocks.COPPER_CHAIN_GEARSHIFT, ModBlocks.COPPER_CONFIGURABLE_GEARBOX),
    RAILWAY((BlockEntry<? extends Block>)AllBlocks.RAILWAY_CASING, ModBlocks.RAILWAY_GEARBOX, ModBlocks.RAILWAY_MIXER, ModBlocks.RAILWAY_PRESS, ModBlocks.RAILWAY_DEPOT, ModBlocks.RAILWAY_CHAIN_DRIVE, ModBlocks.RAILWAY_CHAIN_GEARSHIFT, ModBlocks.RAILWAY_CONFIGURABLE_GEARBOX),
    INDUSTRIAL_IRON((BlockEntry<? extends Block>)AllBlocks.INDUSTRIAL_IRON_BLOCK, ModBlocks.INDUSTRIAL_IRON_GEARBOX, ModBlocks.INDUSTRIAL_IRON_MIXER, ModBlocks.INDUSTRIAL_IRON_PRESS, ModBlocks.INDUSTRIAL_IRON_DEPOT, ModBlocks.INDUSTRIAL_IRON_CHAIN_DRIVE, ModBlocks.INDUSTRIAL_IRON_CHAIN_GEARSHIFT, ModBlocks.INDUSTRIAL_IRON_CONFIGURABLE_GEARBOX),
    CREATIVE(ModBlocks.CREATIVE_CASING, ModBlocks.CREATIVE_GEARBOX, ModBlocks.CREATIVE_MIXER, ModBlocks.CREATIVE_PRESS, ModBlocks.CREATIVE_DEPOT, ModBlocks.CREATIVE_CHAIN_DRIVE, ModBlocks.CREATIVE_CHAIN_GEARSHIFT, ModBlocks.CREATIVE_CONFIGURABLE_GEARBOX);

    private final BlockEntry<? extends Block> casing;
    private final BlockEntry<? extends Block> gearbox;
    private final BlockEntry<? extends Block> mixer;
    private final BlockEntry<? extends Block> press;
    private final BlockEntry<? extends Block> depot;
    private final BlockEntry<? extends Block> chainDrive;
    private final BlockEntry<? extends Block> adjustableChainDrive;
    private final BlockEntry<? extends Block> configurableGearbox;

    private EncasableBlocks(BlockEntry<? extends Block> casing, BlockEntry<? extends Block> gearbox, BlockEntry<? extends Block> mixer, BlockEntry<? extends Block> press, BlockEntry<? extends Block> depot, BlockEntry<? extends Block> chainDrive, BlockEntry<? extends Block> adjustableChainDrive, BlockEntry<? extends Block> configurableGearbox) {
        this.casing = casing;
        this.gearbox = gearbox;
        this.mixer = mixer;
        this.press = press;
        this.depot = depot;
        this.chainDrive = chainDrive;
        this.adjustableChainDrive = adjustableChainDrive;
        this.configurableGearbox = configurableGearbox;
    }

    public static EncasableBlocks getBlockByCasing(BlockState casing) {
        return Arrays.stream(EncasableBlocks.values()).filter(e -> e.casing.has(casing)).findFirst().orElse(null);
    }

    public static EncasableBlocks getBlockByCasing(Item casing) {
        return Arrays.stream(EncasableBlocks.values()).filter(e -> e.casing.is(casing)).findFirst().orElse(null);
    }

    public static boolean hasBlocksForCasing(BlockState casing) {
        return EncasableBlocks.getBlockByCasing(casing) != null;
    }

    public static boolean hasBlocksForCasing(Item casing) {
        return EncasableBlocks.getBlockByCasing(casing) != null;
    }

    public BlockEntry<? extends Block> getCasing() {
        return this.casing;
    }

    public BlockEntry<? extends Block> getGearbox() {
        return this.gearbox;
    }

    public BlockEntry<? extends Block> getMixer() {
        return this.mixer;
    }

    public BlockEntry<? extends Block> getPress() {
        return this.press;
    }

    public BlockEntry<? extends Block> getDepot() {
        return this.depot;
    }

    public BlockEntry<? extends Block> getChainDrive() {
        return this.chainDrive;
    }

    public BlockEntry<? extends Block> getAdjustableChainDrive() {
        return this.adjustableChainDrive;
    }

    public BlockEntry<? extends Block> getConfigurableGearbox() {
        return this.configurableGearbox;
    }

    public static boolean isGearbox(BlockState state) {
        return Arrays.stream(EncasableBlocks.values()).anyMatch(b -> b.getGearbox().has(state));
    }

    public static boolean isMixer(BlockState state) {
        return Arrays.stream(EncasableBlocks.values()).anyMatch(b -> b.getMixer().has(state));
    }

    public static boolean isPress(BlockState state) {
        return Arrays.stream(EncasableBlocks.values()).anyMatch(b -> b.getPress().has(state));
    }

    public static boolean isDepot(BlockState state) {
        return Arrays.stream(EncasableBlocks.values()).anyMatch(b -> b.getDepot().has(state));
    }

    public static boolean isChainDrive(BlockState state) {
        return Arrays.stream(EncasableBlocks.values()).anyMatch(b -> b.getChainDrive().has(state));
    }

    public static boolean isAdjustableChainDrive(BlockState state) {
        return Arrays.stream(EncasableBlocks.values()).anyMatch(b -> b.getAdjustableChainDrive().has(state));
    }

    public static boolean isConfigurableGearbox(BlockState state) {
        return Arrays.stream(EncasableBlocks.values()).anyMatch(b -> b.getConfigurableGearbox().has(state));
    }

    public boolean isInSet(BlockState state) {
        return this.casing.has(state) || this.gearbox.has(state) || this.mixer.has(state) || this.depot.has(state) || this.chainDrive.has(state) || this.adjustableChainDrive.has(state) || this.configurableGearbox.has(state);
    }
}

