/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.screen;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import fr.iglee42.createcasing.blockEntities.BrassShaftBlockEntity;
import fr.iglee42.createcasing.packets.ConfigureBrassShaftPacket;
import fr.iglee42.createcasing.registries.ModGuiTextures;
import fr.iglee42.createcasing.registries.ModIcons;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class BrassShaftScreen
extends AbstractSimiScreen {
    protected BrassShaftBlockEntity be;
    protected ModGuiTextures background = ModGuiTextures.BRASS_SHAFT;
    protected ScrollInput maxStressWidget;
    private SelectionScrollInput scrollInput;
    private Label scrollInputLabel;
    protected List<IconButton> operationButtons;
    protected AbstractSimiWidget brassShaftWidget;
    private IconButton confirmButton;

    public BrassShaftScreen(BrassShaftBlockEntity be) {
        super((Component)be.getBlockState().getBlock().getName());
        this.be = be;
    }

    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        super.init();
        this.clearWidgets();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.brassShaftWidget = new ElementWidget(x + 51, y + 48).showingElement((RenderElement)GuiGameElement.of((ItemLike)this.be.getBlockState().getBlock()));
        this.addRenderableWidget((GuiEventListener)this.brassShaftWidget);
        this.scrollInput = new SelectionScrollInput(x + 51, y + 25, 145, 18);
        this.scrollInputLabel = new Label(x + 53, y + 29, CommonComponents.EMPTY).withShadow();
        this.scrollInput.forOptions(BrassShaftBlockEntity.Mode.getComponents()).titled(Component.translatable((String)"createcasing.brass_shaft.mode")).writingTo(this.scrollInputLabel).setState(this.be.getMode().ordinal());
        this.addRenderableWidgets((GuiEventListener[])new AbstractSimiWidget[]{this.scrollInputLabel, this.scrollInput});
        Label label = new Label(x + 76, y + 52, (Component)Component.empty()).withShadow();
        this.maxStressWidget = new ScrollInput(x + 75, y + 48, 120, 18);
        this.maxStressWidget.withRange(0, Integer.MAX_VALUE).writingTo(label).withStepFunction(context -> context.control ? (context.shift ? 1024 : 512) : (context.shift ? 128 : 1)).titled(Component.translatable((String)"createcasing.brass_shaft.max_stress")).format(i -> Component.literal((String)BrassShaftScreen.addSpacesEveryThreeDigits(i)));
        this.maxStressWidget.setState(this.be.getMaxSupportedStress());
        this.maxStressWidget.onChanged();
        this.addRenderableWidgets((GuiEventListener[])new AbstractSimiWidget[]{label, this.maxStressWidget});
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> ((BrassShaftScreen)this).onClose());
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.operationButtons = new ArrayList<IconButton>(3);
        ImmutableList icons = ImmutableList.of((Object)AllIcons.I_MTD_LEFT, (Object)((Object)ModIcons.I_EQUALS), (Object)AllIcons.I_MTD_RIGHT);
        for (int i2 = 0; i2 < 3; ++i2) {
            IconButton operationButton = new IconButton(x + 33 + i2 * 18, y + this.background.getHeight() - 24, (ScreenElement)icons.get(i2));
            int operation = i2;
            operationButton.withCallback(() -> PacketDistributor.sendToServer((CustomPacketPayload)new ConfigureBrassShaftPacket(this.be.getBlockPos(), this.maxStressWidget.getState(), this.scrollInput.getState(), operation), (CustomPacketPayload[])new CustomPacketPayload[0]));
            operationButton.setToolTip(BrassShaftBlockEntity.Operation.getComponents().get(i2));
            this.operationButtons.add(operationButton);
        }
        this.addRenderableWidgets(this.operationButtons);
    }

    private static String addSpacesEveryThreeDigits(int number) {
        String numberStr = String.valueOf(number);
        StringBuilder formatted = new StringBuilder();
        int length = numberStr.length();
        int count = 0;
        for (int i = length - 1; i >= 0; --i) {
            formatted.insert(0, numberStr.charAt(i));
            if (++count % 3 != 0 || i <= 0) continue;
            formatted.insert(0, " ");
        }
        return formatted.toString();
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemLike)this.be.getBlockState().getBlock()).at((float)(x + this.background.getWidth() - 20), (float)(y + this.background.getHeight() - 56), -200.0f)).scale(5.0).render(graphics);
        graphics.drawString(this.font, this.title, x + (this.background.getWidth() - 8) / 2 - this.font.width((FormattedText)this.title) / 2, y + 4, 5841956, false);
    }

    public void tick() {
        super.tick();
        for (int operation = 0; operation < this.operationButtons.size(); ++operation) {
            this.operationButtons.get((int)operation).green = operation == this.be.getOperation().ordinal();
        }
    }

    public void removed() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ConfigureBrassShaftPacket(this.be.getBlockPos(), this.maxStressWidget.getState(), this.scrollInput.getState(), this.be.getOperation().ordinal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

