/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blockEntities.visuals;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import fr.iglee42.createcasing.registries.ModPartialModels;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;

public class CustomMixerVisual
extends SingleAxisRotatingVisual<MechanicalMixerBlockEntity>
implements SimpleDynamicVisual {
    private RotatingInstance mixerHead;
    private OrientedInstance mixerPole;
    private final MechanicalMixerBlockEntity mixer;

    public CustomMixerVisual(VisualizationContext context, MechanicalMixerBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial((PartialModel)AllPartialModels.SHAFTLESS_COGWHEEL));
        this.mixer = blockEntity;
        this.mixerPole = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_POLE)).createInstance();
        this.mixerHead = switch (BuiltInRegistries.BLOCK.getKey((Object)this.mixer.getBlockState().getBlock()).getPath().replace("_mixer", "").toLowerCase()) {
            case "brass" -> (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)ModPartialModels.BRASS_MIXER_HEAD)).createInstance();
            case "copper" -> (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)ModPartialModels.COPPER_MIXER_HEAD)).createInstance();
            case "railway" -> (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)ModPartialModels.RAILWAY_MIXER_HEAD)).createInstance();
            case "industrial_iron" -> (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)ModPartialModels.INDUSTRIAL_IRON_MIXER_HEAD)).createInstance();
            case "creative" -> (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)ModPartialModels.CREATIVE_MIXER_HEAD)).createInstance();
            default -> (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_HEAD)).createInstance();
        };
        this.mixerHead.setRotationAxis(Direction.Axis.Y);
        this.animate(partialTick);
    }

    private void animate(float pt) {
        float renderedHeadOffset = this.mixer.getRenderedHeadOffset(pt);
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset, pt);
    }

    private void transformHead(float renderedHeadOffset, float pt) {
        float speed = this.mixer.getRenderedHeadRotationSpeed(pt);
        this.mixerHead.setPosition((Vec3i)this.getVisualPosition()).nudge(0.0f, -renderedHeadOffset, 0.0f).setRotationalSpeed(speed * 2.0f * 6.0f).setChanged();
    }

    private void transformPole(float renderedHeadOffset) {
        this.mixerPole.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.pos.below(), new FlatLit[]{this.mixerHead});
        this.relight(new FlatLit[]{this.mixerPole});
    }

    protected void _delete() {
        super._delete();
        this.mixerHead.delete();
        this.mixerPole.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.mixerHead);
        consumer.accept((Instance)this.mixerPole);
    }

    public void beginFrame(DynamicVisual.Context context) {
        this.animate(context.partialTick());
    }
}

