/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.network.s2c;

import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.BoatPenguinsAttachment;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;

public record SyncBoatPenguinsAttachmentPacketS2C(int entityId, Optional<BoatPenguinsAttachment> attachment) implements CustomPacketPayload
{
    public static final ResourceLocation ID = RapscallionsAndRockhoppers.asResource("sync_boat_penguins_attachment");
    public static final CustomPacketPayload.Type<SyncBoatPenguinsAttachmentPacketS2C> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncBoatPenguinsAttachmentPacketS2C> STREAM_CODEC = StreamCodec.of(SyncBoatPenguinsAttachmentPacketS2C::write, SyncBoatPenguinsAttachmentPacketS2C::new);

    public SyncBoatPenguinsAttachmentPacketS2C(FriendlyByteBuf buf) {
        this(buf.readInt(), (Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec(BoatPenguinsAttachment.CODEC)).decode((Object)buf));
    }

    public static void write(FriendlyByteBuf buf, SyncBoatPenguinsAttachmentPacketS2C packet) {
        buf.writeInt(packet.entityId);
        ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec(BoatPenguinsAttachment.CODEC)).encode((Object)buf, packet.attachment);
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId());
            if (!(entity instanceof Boat)) {
                RapscallionsAndRockhoppers.LOG.warn("Could not sync boat penguins attachment.");
                return;
            }
            Boat boat = (Boat)entity;
            if (this.attachment.isEmpty()) {
                RapscallionsAndRockhoppers.getHelper().removeBoatPenguinData(boat);
                return;
            }
            RapscallionsAndRockhoppers.getHelper().getBoatPenguinData(boat).setFrom(this.attachment.get());
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

