/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.network.s2c;

import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.BoatLinksAttachment;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;

public record SyncBoatLinksAttachmentPacketS2C(int entityId, Optional<BoatLinksAttachment> attachment) implements CustomPacketPayload
{
    public static final ResourceLocation ID = RapscallionsAndRockhoppers.asResource("sync_boat_link_attachment");
    public static final CustomPacketPayload.Type<SyncBoatLinksAttachmentPacketS2C> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncBoatLinksAttachmentPacketS2C> STREAM_CODEC = StreamCodec.of(SyncBoatLinksAttachmentPacketS2C::write, SyncBoatLinksAttachmentPacketS2C::new);

    public SyncBoatLinksAttachmentPacketS2C(FriendlyByteBuf buf) {
        this(buf.readInt(), (Optional)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec(BoatLinksAttachment.CODEC)).decode((Object)buf));
    }

    public static void write(FriendlyByteBuf buf, SyncBoatLinksAttachmentPacketS2C packet) {
        buf.writeInt(packet.entityId);
        ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec(BoatLinksAttachment.CODEC)).encode((Object)buf, packet.attachment);
    }

    public void handle() {
        Minecraft.getInstance().execute(() -> {
            Entity entity = Minecraft.getInstance().level.getEntity(this.entityId());
            if (!(entity instanceof Boat)) {
                RapscallionsAndRockhoppers.LOG.warn("Could not sync boat link attachment.");
                return;
            }
            Boat boat = (Boat)entity;
            if (this.attachment.isEmpty()) {
                RapscallionsAndRockhoppers.getHelper().removeBoatData(boat);
                return;
            }
            RapscallionsAndRockhoppers.getHelper().getBoatData(boat).setFrom(this.attachment.get());
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

