/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.modifiers;

import com.mojang.serialization.MapCodec;
import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersBiomeModifiers;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record AddPenguinSpawnsModifier(List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (RapscallionsAndRockhoppers.getBiomePopulationPenguinTypeRegistry().stream().anyMatch(penguinType -> penguinType.biomes().unwrap().stream().anyMatch(holderSet -> ((HolderSet)holderSet.data()).contains(biome))) && phase == BiomeModifier.Phase.ADD) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                spawns.addSpawn(MobCategory.CREATURE, spawner);
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return RockhoppersBiomeModifiers.ADD_PENGUIN_SPAWNS_MODIFIER.get();
    }
}

