/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.BoatLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.client.renderer.BoatHookLeashRenderer;
import house.greenhouse.rapscallionsandrockhoppers.entity.BoatHookFenceKnotEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin<T extends Entity> {
    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void addBoatHookRenderering(T entity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, CallbackInfo ci) {
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            BoatLinksAttachment boatData = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
            boatData.getPreviousLinkedBoats(entity.level()).forEach(previous -> BoatHookLeashRenderer.renderLeash(boat, yaw, tickDelta, poseStack, bufferSource, (Entity)previous));
            if (boatData.getLinkedPlayer(entity.level()) != null) {
                BoatHookLeashRenderer.renderLeash(boat, yaw, tickDelta, poseStack, bufferSource, (Entity)boatData.getLinkedPlayer(entity.level()));
            } else if (boatData.getHookKnot(entity.level()) != null) {
                BoatHookLeashRenderer.renderLeash(boat, yaw, tickDelta, poseStack, bufferSource, (Entity)boatData.getHookKnot(entity.level()));
            }
        }
    }

    @Inject(method={"shouldRender"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Leashable;getLeashHolder()Lnet/minecraft/world/entity/Entity;")}, cancellable=true)
    public void shouldRenderBoatHook(T livingEntity, Frustum camera, double camX, double camY, double camZ, CallbackInfoReturnable<Boolean> cir) {
        if (livingEntity instanceof Boat) {
            BoatHookFenceKnotEntity boatKnot;
            Boat boat = (Boat)livingEntity;
            if (RapscallionsAndRockhoppers.getHelper().getBoatData(boat).getHookKnotUuid().isPresent() && (boatKnot = RapscallionsAndRockhoppers.getHelper().getBoatData(boat).getHookKnot(boat.level())) != null) {
                cir.setReturnValue((Object)camera.isVisible(boatKnot.getBoundingBoxForCulling()));
            }
        }
    }
}

