/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private boolean rapscallionsandrockhoppers$previousWaterState = false;

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyReturnValue(method={"getFrictionInfluencedSpeed"}, at={@At(value="RETURN")})
    private float rapscallionsandrockhoppers$modifyPenguinFrictionWhenStumble(float original) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Penguin) {
            Penguin penguin = (Penguin)livingEntity;
            if (penguin.isStumbling()) {
                return original * 1.8f;
            }
            if (penguin.getBlockStateOn().is(BlockTags.ICE)) {
                return original * 1.2f;
            }
        }
        return original;
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="HEAD")}, cancellable=true)
    private void rapscallionsandrockhoppers$dontDropLootIfKilledByPenguin(DamageSource source, boolean useLastDamagePlayer, CallbackInfo ci) {
        if (source.getEntity() instanceof Penguin) {
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isAffectedByFluids()Z")})
    public boolean rapscallionsandrockhoppers$makeNotEffectedByWaterIfSinking(boolean original) {
        if (this.isInWater() && this.hasEffect(RockhoppersMobEffects.SINKING)) {
            return false;
        }
        return original;
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void rapscallionsandrockhoppers$sinkingAttributes(Vec3 travelVector, CallbackInfo ci) {
        if (this.isUnderWater() && this.hasEffect(RockhoppersMobEffects.SINKING)) {
            RockhoppersMobEffects.applySinkingModifiers((LivingEntity)this);
            this.rapscallionsandrockhoppers$previousWaterState = true;
        } else if (this.rapscallionsandrockhoppers$previousWaterState) {
            RockhoppersMobEffects.removeSinkingModifiers((LivingEntity)this);
            this.rapscallionsandrockhoppers$previousWaterState = false;
        }
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWater()Z")})
    public boolean rapscallionsandrockhoppers$jumpMakeNotEffectedByWaterIfSinking(boolean original) {
        if (this.isInWater() && this.hasEffect(RockhoppersMobEffects.SINKING)) {
            return false;
        }
        return original;
    }
}

