/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.mixin;

import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.BoatLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.attachment.PlayerLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public abstract void setSwimming(boolean var1);

    @Shadow
    public abstract boolean isSwimming();

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void bovinesandbuttercups$loadFromLegacyAttachments(CompoundTag tag, CallbackInfo ci) {
        CompoundTag legacyTag;
        Object attachment;
        Entity entity = (Entity)this;
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            attachment = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
            legacyTag = RapscallionsAndRockhoppers.getHelper().getLegacyTagStart(tag).getCompound("rapscallionsandrockhoppers:boat_data");
            if (attachment != null && !legacyTag.isEmpty()) {
                ((BoatLinksAttachment)attachment).deserializeLegacyData(legacyTag);
            }
        }
        if ((attachment = (Entity)this) instanceof Player) {
            Player player = (Player)attachment;
            attachment = RapscallionsAndRockhoppers.getHelper().getPlayerData(player);
            legacyTag = RapscallionsAndRockhoppers.getHelper().getLegacyTagStart(tag).getCompound("rapscallionsandrockhoppers:boat_data");
            if (attachment != null && !legacyTag.isEmpty()) {
                ((PlayerLinksAttachment)attachment).deserializeLegacyData(legacyTag);
            }
        }
    }

    @Inject(method={"updateSwimming"}, at={@At(value="HEAD")}, cancellable=true)
    private void rapscallionsandrockhoppers$shouldUnsetSwimmingIfSinking(CallbackInfo ci) {
        LivingEntity living;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).hasEffect(RockhoppersMobEffects.SINKING)) {
            if (this.isSwimming()) {
                this.setSwimming(false);
            }
            ci.cancel();
        }
    }
}

