/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.item;

import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.BoatLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.attachment.PlayerLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.entity.BoatHookFenceKnotEntity;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class BoatHookItem
extends Item {
    public BoatHookItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = context.getClickedPos());
        if (blockstate.is(BlockTags.FENCES)) {
            Player player = context.getPlayer();
            if (!level.isClientSide && player != null && BoatHookItem.attemptCreateBoatKnot(player, level, blockpos).consumesAction() && !player.getAbilities().instabuild) {
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult attemptCreateBoatKnot(Player player, Level level, BlockPos pos) {
        if (!RapscallionsAndRockhoppers.getHelper().hasPlayerData(player)) {
            return InteractionResult.PASS;
        }
        BoatHookFenceKnotEntity boatHookFenceKnot = null;
        PlayerLinksAttachment playerData = RapscallionsAndRockhoppers.getHelper().getPlayerData(player);
        Set<Boat> set = playerData.getLinkedBoats(level);
        Iterator<Boat> iterator = set.iterator();
        while (iterator.hasNext()) {
            Boat value;
            Boat boat = value = iterator.next();
            BoatLinksAttachment boatData = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
            if (boatHookFenceKnot == null) {
                boatHookFenceKnot = BoatHookFenceKnotEntity.getOrCreate(level, pos);
                boatHookFenceKnot.playPlacementSound();
            }
            boatData.setHookKnotUuid(boatHookFenceKnot.getUUID());
            boatData.setLinkedPlayerUuid(null);
            playerData.removeLinkedBoat(boat.getUUID());
            if (!boatData.hasData()) {
                RapscallionsAndRockhoppers.getHelper().removeBoatData(boat);
            }
            if (playerData.getLinkedBoatUUIDs().isEmpty()) {
                RapscallionsAndRockhoppers.getHelper().removePlayerData(player);
            }
            if (boat.level().isClientSide()) continue;
            RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
        }
        if (!player.level().isClientSide()) {
            RapscallionsAndRockhoppers.getHelper().syncPlayerData(player);
        }
        if (!set.isEmpty()) {
            level.gameEvent((Holder)GameEvent.BLOCK_ATTACH, pos, GameEvent.Context.of((Entity)player));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

