/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.sensor;

import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSensorTypes;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PlayerToCoughForSensor
extends PredicateSensor<Boat, Penguin> {
    public List<MemoryModuleType<?>> memoriesUsed() {
        return List.of(RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR);
    }

    protected void doTick(ServerLevel level, Penguin penguin) {
        if (penguin.isEyeInFluid(FluidTags.WATER)) {
            BrainUtils.clearMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR);
        }
        if (BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.FISH_EATEN) && !BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR)) {
            UUID uuid = (UUID)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER);
            if (uuid == null) {
                uuid = (UUID)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.FED_BY);
            }
            if (uuid == null) {
                return;
            }
            Entity entity = level.getEntity(uuid);
            if (entity != null && entity.onGround() && !entity.isEyeInFluid(FluidTags.WATER) && entity.level().getBlockState(entity.getOnPos()).isCollisionShapeFullBlock((BlockGetter)entity.level(), entity.getOnPos()) && penguin.distanceTo(entity) < 16.0f) {
                BrainUtils.setMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR, (Object)uuid);
            }
        } else {
            UUID uuid = (UUID)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR);
            if (uuid == null) {
                uuid = (UUID)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.FED_BY);
            }
            if (uuid == null) {
                return;
            }
            Entity entity = level.getEntity(uuid);
            if (entity == null || entity.isEyeInFluid(FluidTags.WATER) || !entity.level().getBlockState(entity.getOnPos()).isCollisionShapeFullBlock((BlockGetter)entity.level(), entity.getOnPos()) || penguin.distanceTo(entity) > 16.0f) {
                BrainUtils.clearMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR);
            }
        }
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return RockhoppersSensorTypes.BOAT_TO_FOLLOW;
    }
}

