/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.sensor;

import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSensorTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class PenguinHomeSensor
extends ExtendedSensor<Penguin> {
    public List<MemoryModuleType<?>> memoriesUsed() {
        return List.of(MemoryModuleType.HOME);
    }

    protected void doTick(ServerLevel level, Penguin penguin) {
        if (BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW) && penguin.tickCount % 20 != 0) {
            return;
        }
        Optional<GlobalPos> homePos = Optional.ofNullable(this.getHomePos(penguin));
        if (homePos.isPresent() && (!BrainUtils.hasMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.HOME) || homePos.get().pos().distToCenterSqr((Position)penguin.position()) > 576.0)) {
            BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.HOME, (Object)homePos.orElse(null));
        }
    }

    @Nullable
    protected GlobalPos getHomePos(Penguin penguin) {
        ResourceKey levelResourceKey = penguin.level().dimension();
        if (levelResourceKey != Level.OVERWORLD) {
            return null;
        }
        if (penguin.isInWaterOrBubble() && !BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.IS_JUMPING)) {
            BlockPos.MutableBlockPos mutableBlockPos = penguin.blockPosition().mutable();
            while (penguin.level().getFluidState((BlockPos)mutableBlockPos).is(FluidTags.WATER)) {
                mutableBlockPos.move(Direction.UP);
            }
            BlockPos immutableBlockPos = mutableBlockPos.immutable();
            return GlobalPos.of((ResourceKey)levelResourceKey, (BlockPos)immutableBlockPos);
        }
        return null;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return RockhoppersSensorTypes.PENGUIN_HOME;
    }
}

