/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.sensor;

import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSensorTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class NearbyWaterSensor
extends ExtendedSensor<Penguin> {
    private int xzRadius = 8;
    private int yRadius = 4;

    public List<MemoryModuleType<?>> memoriesUsed() {
        return List.of(RockhoppersMemoryModuleTypes.NEAREST_WATER);
    }

    public NearbyWaterSensor setXZRadius(int xzRadius) {
        this.xzRadius = xzRadius;
        return this;
    }

    public NearbyWaterSensor setYRadius(int yRadius) {
        this.yRadius = yRadius;
        return this;
    }

    protected void doTick(ServerLevel level, Penguin entity) {
        Optional waterPos = BlockPos.findClosestMatch((BlockPos)entity.blockPosition(), (int)this.xzRadius, (int)this.yRadius, pos -> level.getFluidState(pos).is(FluidTags.WATER) && level.getFluidState(pos.above()).isEmpty() && level.getBlockState(pos.above()).isAir());
        BrainUtils.setMemory((LivingEntity)entity, RockhoppersMemoryModuleTypes.NEAREST_WATER, (Object)waterPos.orElse(null));
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return RockhoppersSensorTypes.NEARBY_WATER;
    }
}

