/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.sensor;

import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersBlocks;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSensorTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class NearbyEggSensor
extends ExtendedSensor<Penguin> {
    private int radius = 8;

    public SensorType<? extends ExtendedSensor<?>> type() {
        return RockhoppersSensorTypes.NEARBY_EGG;
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return List.of(RockhoppersMemoryModuleTypes.EGG_POS);
    }

    protected void doTick(ServerLevel level, Penguin penguin) {
        if (!BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.EGG_POS)) {
            AABB boundingBox = new AABB(penguin.blockPosition()).inflate((double)this.radius);
            List penguinsInArea = level.getEntitiesOfClass(Penguin.class, boundingBox);
            penguinsInArea.removeIf(otherPenguin -> otherPenguin == penguin);
            BlockPos firstPos = penguin.blockPosition().offset(-this.radius, -this.radius, -this.radius);
            BlockPos lastPos = penguin.blockPosition().offset(this.radius, this.radius, this.radius);
            for (BlockPos eggBlockPos : BlockPos.betweenClosed((BlockPos)firstPos, (BlockPos)lastPos)) {
                if (!level.getBlockState(eggBlockPos).is(RockhoppersBlocks.PENGUIN_EGG) || !penguinsInArea.stream().noneMatch(otherPenguin -> otherPenguin.blockPosition().distSqr((Vec3i)eggBlockPos) < 1.0)) continue;
                penguin.getBrain().setMemory(RockhoppersMemoryModuleTypes.EGG_POS, (Object)eggBlockPos);
                return;
            }
        }
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }
}

