/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.sensor;

import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSensorTypes;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class NearbyBobbersSensor
extends PredicateSensor<FishingHook, Penguin> {
    private Vec3 previousBoatPos;
    @Nullable
    protected SquareRadius radius;

    public NearbyBobbersSensor() {
        this.setScanRate(penguin -> 20);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return List.of(RockhoppersMemoryModuleTypes.NEAREST_BOBBERS);
    }

    public NearbyBobbersSensor setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyBobbersSensor setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    protected void doTick(ServerLevel level, Penguin penguin) {
        if (BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW) && penguin.getBoatToFollow() != null) {
            if (this.previousBoatPos == null) {
                this.previousBoatPos = penguin.getBoatToFollow().position();
            }
            boolean bl = this.previousBoatPos.subtract(penguin.getBoatToFollow().position()).horizontalDistance() > 0.075;
            this.previousBoatPos = penguin.getBoatToFollow().position();
            if (bl) {
                BrainUtils.clearMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.NEAREST_BOBBERS);
                return;
            }
        } else if (this.previousBoatPos != null) {
            this.previousBoatPos = null;
        }
        if (this.radius == null) {
            double dist = penguin.getAttributeValue(Attributes.FOLLOW_RANGE);
            this.radius = new SquareRadius(dist, dist);
        }
        List bobbers = EntityRetrievalUtil.getEntities((Level)level, (AABB)penguin.getBoundingBox().inflate(this.radius.xzRadius(), this.radius.yRadius(), this.radius.xzRadius()), entity -> {
            if (!(entity instanceof FishingHook)) return false;
            FishingHook fishingHook = (FishingHook)entity;
            if (!this.predicate().test(fishingHook, penguin)) return false;
            return true;
        });
        bobbers.sort(Comparator.comparingDouble(arg_0 -> ((Penguin)penguin).distanceToSqr(arg_0)));
        penguin.getBrain().setMemory(RockhoppersMemoryModuleTypes.NEAREST_BOBBERS, (Object)bobbers);
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return RockhoppersSensorTypes.NEAREST_BOBBERS_SENSOR;
    }
}

