/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.sensor;

import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.BoatPenguinsAttachment;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSensorTypes;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class BoatToFollowSensor
extends PredicateSensor<Boat, Penguin> {
    @Nullable
    private SquareRadius radius = null;
    @Nullable
    private SquareRadius updatePenguinRadius = null;

    public BoatToFollowSensor() {
        this.setScanRate(penguin -> 5);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return List.of(RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER);
    }

    public BoatToFollowSensor setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public BoatToFollowSensor setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public BoatToFollowSensor setUpdatePenguinRadius(double xz, double y) {
        this.updatePenguinRadius = new SquareRadius(xz, y);
        return this;
    }

    protected void doTick(ServerLevel level, Penguin penguin) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = penguin.getAttributeValue(Attributes.FOLLOW_RANGE);
            radius = new SquareRadius(dist, dist);
        }
        if (penguin.getBoatToFollow() == null && penguin.getTimeAllowedToFollowBoat() <= 0 && !penguin.isBaby()) {
            Optional<Boat> boat = EntityRetrievalUtil.getEntities((Level)level, (AABB)radius.inflateAABB(penguin.getBoundingBox()), obj -> {
                Boat b;
                return obj instanceof Boat && (b = (Boat)obj).hasControllingPassenger() && RapscallionsAndRockhoppers.getHelper().getBoatPenguinData(b).penguinCount() < 3;
            }).stream().min(Comparator.comparingInt(b -> RapscallionsAndRockhoppers.getHelper().getBoatPenguinData((Boat)b).penguinCount()));
            if (boat.isPresent()) {
                penguin.setBoatToFollow(boat.get().getUUID());
                if (this.updatePenguinRadius != null) {
                    EntityRetrievalUtil.getEntities((Level)level, (AABB)this.updatePenguinRadius.inflateAABB(penguin.getBoundingBox()), obj -> obj instanceof Penguin && obj.isAlive()).forEach(p -> p.setTimeAllowedToFollowBoat(Optional.of(20)));
                }
                BoatPenguinsAttachment boatPenguins = RapscallionsAndRockhoppers.getHelper().getBoatPenguinData(boat.get());
                boatPenguins.addFollowingPenguin(penguin.getUUID());
                boatPenguins.sync();
                penguin.setHungryTime(Optional.of(2400));
                penguin.setTimeAllowedToEat(Optional.of(120));
                ((ServerLevel)penguin.level()).sendParticles((ParticleOptions)ParticleTypes.GLOW, boat.get().getX(), boat.get().getY(), boat.get().getZ(), 8, 0.5, 0.25, 0.5, 0.02);
                penguin.previousBoatPos = penguin.getBoatToFollow().position();
            }
        } else if (BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW)) {
            Boat boat = penguin.getBoatToFollow();
            if (boat != null && boat.getControllingPassenger() instanceof Player) {
                BrainUtils.setMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER, (Object)boat.getControllingPassenger().getUUID());
            }
            if (boat == null || boat.isRemoved()) {
                penguin.setBoatToFollow(null);
                BrainUtils.clearMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER);
            }
        }
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return RockhoppersSensorTypes.BOAT_TO_FOLLOW;
    }
}

