/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.util.EntityGetUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class WalkToRewardedPlayer
extends ExtendedBehaviour<Penguin> {
    private Vec3 runPos = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of(RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        UUID playerUuid = (UUID)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR);
        Entity rewardedPlayer = EntityGetUtil.getEntityFromUuid((Level)level, playerUuid);
        if (playerUuid == null || rewardedPlayer == null) {
            return false;
        }
        double distToTarget = penguin.distanceToSqr(rewardedPlayer);
        if (distToTarget < 4.0) {
            return false;
        }
        Vec3 runPos = DefaultRandomPos.getPosTowards((PathfinderMob)penguin, (int)16, (int)8, (Vec3)rewardedPlayer.position(), (double)1.5707963705062866);
        if (runPos == null || rewardedPlayer.distanceToSqr(runPos) > distToTarget) {
            return false;
        }
        this.runPos = runPos;
        return true;
    }

    protected void start(Penguin penguin) {
        BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.runPos, 1.0f, 1));
    }

    protected void stop(Penguin penguin) {
        this.runPos = null;
    }
}

