/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class StayWithinHome
extends ExtendedBehaviour<Penguin> {
    private int radius = 0;
    private Vec3 runPos = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of((Object)MemoryModuleType.HOME, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT));
    }

    public StayWithinHome setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        GlobalPos target = (GlobalPos)BrainUtils.getMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.HOME);
        if (target == null || target.dimension() != level.dimension()) {
            return false;
        }
        double distToTarget = penguin.blockPosition().distSqr((Vec3i)target.pos());
        if (distToTarget < (double)(this.radius * this.radius)) {
            return false;
        }
        Vec3 runPos = DefaultRandomPos.getPosTowards((PathfinderMob)penguin, (int)(this.radius * 2), (int)3, (Vec3)Vec3.atBottomCenterOf((Vec3i)target.pos()), (double)0.3141592741012573);
        if (runPos == null) {
            runPos = DefaultRandomPos.getPosTowards((PathfinderMob)penguin, (int)this.radius, (int)7, (Vec3)Vec3.atBottomCenterOf((Vec3i)target.pos()), (double)1.5707963705062866);
        }
        if (runPos == null || target.pos().distSqr((Vec3i)BlockPos.containing((Position)runPos)) > distToTarget) {
            return false;
        }
        this.runPos = runPos;
        return true;
    }

    protected void start(Penguin penguin) {
        BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.runPos, 1.0f, 2));
    }

    protected void stop(Penguin penguin) {
        this.runPos = null;
    }
}

