/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class StayWithinBoat
extends ExtendedBehaviour<Penguin> {
    private int radius = 0;
    private Vec3 runPos = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of(RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT));
    }

    public StayWithinBoat setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        Boat boat = penguin.getBoatToFollow();
        if (boat == null) {
            return false;
        }
        double distToTarget = penguin.distanceToSqr((Entity)boat);
        if (distToTarget < (double)(this.radius * this.radius)) {
            return false;
        }
        Vec3 runPos = DefaultRandomPos.getPosTowards((PathfinderMob)penguin, (int)this.radius, (int)10, (Vec3)boat.position(), (double)1.5707963705062866);
        if (runPos == null || boat.position().distanceToSqr(runPos) > distToTarget) {
            return false;
        }
        this.runPos = runPos;
        return true;
    }

    protected void start(Penguin penguin) {
        BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(this.runPos, 1.0f, 4));
    }

    protected void stop(Penguin penguin) {
        this.runPos = null;
    }
}

