/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SitAtSurfaceOfWater
extends ExtendedBehaviour<Penguin> {
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of(RockhoppersMemoryModuleTypes.CAUGHT_BOBBER, (Object)MemoryStatus.VALUE_ABSENT), Pair.of(RockhoppersMemoryModuleTypes.NEAREST_BOBBERS, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean shouldKeepRunning(Penguin entity) {
        return !BrainUtils.hasMemory((LivingEntity)entity, RockhoppersMemoryModuleTypes.CAUGHT_BOBBER);
    }

    protected boolean shouldSit(ServerLevel level, Penguin entity) {
        return entity.getFluidHeight(FluidTags.WATER) > 0.2 && entity.getFluidHeight(FluidTags.WATER) < 0.4;
    }

    protected void tick(Penguin entity) {
        if (this.shouldSit((ServerLevel)entity.level(), entity)) {
            entity.getNavigation().stop();
            if (!BrainUtils.hasMemory((LivingEntity)entity, RockhoppersMemoryModuleTypes.NEAREST_BOBBERS)) {
                return;
            }
            Optional hook = ((List)BrainUtils.getMemory((LivingEntity)entity, RockhoppersMemoryModuleTypes.NEAREST_BOBBERS)).stream().findFirst();
            hook.ifPresent(fishingHook -> entity.lookAt(EntityAnchorArgument.Anchor.EYES, fishingHook.position()));
        } else if (entity.getFluidHeight(FluidTags.WATER) < 0.2) {
            entity.addDeltaMovement(new Vec3(0.0, -0.01, 0.0));
        } else {
            entity.addDeltaMovement(new Vec3(0.0, 0.01, 0.0));
        }
    }
}

