/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PenguinStumble
extends ExtendedBehaviour<Penguin> {
    private boolean hasSlid = false;

    public PenguinStumble() {
        this.runFor(Penguin::getTotalStumbleAnimationLength);
    }

    public boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        boolean bl;
        boolean bl2 = bl = penguin.getVehicle() == null && (penguin.isStumbling() || BrainUtils.hasMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET) && penguin.getRandom().nextFloat() < Mth.clamp((float)penguin.getStumbleChance(), (float)0.0f, (float)1.0f));
        if (bl && !penguin.isStumbling()) {
            penguin.setStumbleTicks(0);
            penguin.setStumbleTicksBeforeGettingUp(penguin.getRandom().nextIntBetweenInclusive(30, 60));
        }
        return bl;
    }

    protected boolean shouldKeepRunning(Penguin penguin) {
        return penguin.getStumbleTicks() <= penguin.getTotalStumbleAnimationLength();
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT));
    }

    public void tick(Penguin penguin) {
        if (penguin.getStumbleTicks() > 30 && !this.hasSlid) {
            float i = (float)Math.PI / 180;
            penguin.addDeltaMovement(penguin.getViewVector(0.0f).multiply(1.0, 0.0, 1.0).normalize().multiply(0.4, 0.0, 0.4));
            penguin.hurtMarked = true;
            this.hasSlid = true;
        }
        penguin.setStumbleTicks(penguin.getStumbleTicks() + 1);
    }

    public void start(Penguin penguin) {
        BrainUtils.clearMemories((LivingEntity)penguin, (MemoryModuleType[])new MemoryModuleType[]{MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET});
    }

    public void stop(Penguin penguin) {
        penguin.setStumbleTicks(Integer.MIN_VALUE);
        penguin.setStumbleTicksBeforeGettingUp(Integer.MIN_VALUE);
        this.hasSlid = false;
    }
}

