/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.block.PenguinEggBlock;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersBlocks;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PenguinSitEgg
extends ExtendedBehaviour<Penguin> {
    public static final int EGG_CRACK_TIME = 6000;
    private int eggCrackTime = 6000;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of(RockhoppersMemoryModuleTypes.EGG_POS, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected void tick(ServerLevel level, Penguin penguin, long gameTime) {
        super.tick(level, (LivingEntity)penguin, gameTime);
        BlockPos eggPos = (BlockPos)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.EGG_POS);
        assert (eggPos != null);
        if (!level.getBlockState(eggPos).is(RockhoppersBlocks.PENGUIN_EGG)) {
            BrainUtils.clearMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.EGG_POS);
            BrainUtils.clearMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
            return;
        }
        if (penguin.distanceToSqr(eggPos.getX(), eggPos.getY(), eggPos.getZ()) < 1.2) {
            BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(eggPos, 1.0f, 1));
            --this.eggCrackTime;
            if (this.eggCrackTime <= 0) {
                PenguinEggBlock.crackEgg(level.getBlockState(eggPos), level, eggPos);
                this.eggCrackTime = 6000;
            }
        }
    }

    protected boolean shouldKeepRunning(Penguin entity) {
        return BrainUtils.hasMemory((LivingEntity)entity, RockhoppersMemoryModuleTypes.EGG_POS);
    }

    protected void start(Penguin penguin) {
        this.eggCrackTime = 6000;
        BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((BlockPos)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.EGG_POS), 1.0f, 1));
    }
}

