/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.network.s2c.SyncBlockPosLookPacketS2C;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PenguinShove
extends ExtendedBehaviour<Penguin> {
    private Penguin shoveTarget;
    private Vec3 lookPos;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of(RockhoppersMemoryModuleTypes.NEAREST_WATER, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        if (penguin.isInWaterOrBubble() || penguin.isStumbling() || penguin.isBaby() || penguin.getShoveTicks() != Integer.MIN_VALUE || ((BlockPos)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.NEAREST_WATER)).distManhattan((Vec3i)penguin.blockPosition()) > 4) {
            return false;
        }
        if (penguin.getRandom().nextFloat() < Mth.clamp((float)penguin.getShoveChance(), (float)0.0f, (float)1.0f)) {
            Penguin shoveTarget = (Penguin)((Object)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.NEAREST_VISIBLE_SHOVEABLE));
            if (shoveTarget == null || !((double)shoveTarget.distanceTo((Entity)penguin) < 2.5)) {
                return false;
            }
            this.shoveTarget = shoveTarget;
            BlockPos lookPos = (BlockPos)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.NEAREST_WATER);
            if (lookPos != null) {
                this.lookPos = new Vec3((double)lookPos.getX(), penguin.getY(), (double)lookPos.getZ());
                return true;
            }
            this.shoveTarget = null;
            this.lookPos = null;
        }
        return false;
    }

    public void start(Penguin penguin) {
        penguin.getLookControl().setLookAt(this.lookPos);
        this.shoveTarget.getLookControl().setLookAt(this.lookPos);
        RapscallionsAndRockhoppers.getHelper().sendS2CTracking(new SyncBlockPosLookPacketS2C(penguin.getId(), this.shoveTarget.getId(), this.lookPos), (Entity)penguin);
        penguin.setShoveTicks(40);
        this.shoveTarget.stumbleWithoutInitialAnimation();
    }

    public void stop(Penguin penguin) {
        this.shoveTarget = null;
        this.lookPos = null;
    }
}

