/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PenguinPeck
extends AnimatableMeleeAttack<Penguin> {
    public PenguinPeck(int delayTicks) {
        super(delayTicks);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of(RockhoppersMemoryModuleTypes.HUNGRY_TIME, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected void start(Penguin penguin) {
        penguin.setPeckTicks(0);
        BehaviorUtils.lookAtEntity((LivingEntity)penguin, (LivingEntity)this.target);
    }

    protected void doDelayedAction(Penguin penguin) {
        BrainUtils.setForgettableMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)((Integer)this.attackIntervalSupplier.apply(penguin)));
        if (this.target != null && penguin.getSensing().hasLineOfSight((Entity)this.target) && penguin.isWithinMeleeAttackRange(this.target) && this.target.isAlive()) {
            penguin.doHurtTarget((Entity)this.target);
            if (!this.target.isAlive()) {
                this.target.remove(Entity.RemovalReason.KILLED);
                penguin.setHungryTime(Optional.of(2400));
                penguin.setTimeAllowedToEat(Optional.of(120));
                penguin.incrementFishEaten();
                BrainUtils.clearMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
                BrainUtils.clearMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
            }
        }
    }

    protected void stop(Penguin penguin) {
        this.target = null;
    }
}

