/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PenguinJump
extends ExtendedBehaviour<Penguin> {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7, 8};
    private boolean breached;

    protected boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        if (penguin.getTimeAllowedToWaterJump() <= 0 || penguin.getAirSupply() > 260) {
            return false;
        }
        Direction direction = penguin.getMotionDirection();
        int x = direction.getStepX();
        int z = direction.getStepZ();
        BlockPos blockPos = penguin.blockPosition();
        for (int step : STEPS_TO_CHECK) {
            if (this.waterIsClear(level, blockPos, x, z, step) && this.surfaceIsClear(level, blockPos, x, z, step)) continue;
            return false;
        }
        return true;
    }

    private boolean waterIsClear(ServerLevel level, BlockPos pos, int x, int z, int step) {
        BlockPos blockPos = pos.offset(x * step, 0, z * step);
        return level.getFluidState(blockPos).is(FluidTags.WATER) && !level.getBlockState(blockPos).blocksMotion();
    }

    private boolean surfaceIsClear(ServerLevel level, BlockPos pos, int x, int z, int step) {
        BlockPos blockPos = pos.offset(x * step, 1, z * step);
        return level.getBlockState(blockPos).isAir() && level.getBlockState(blockPos).isAir();
    }

    public boolean shouldKeepRunning(Penguin penguin) {
        double yMovement = penguin.getDeltaMovement().y();
        return !(yMovement * yMovement < (double)0.03f && penguin.getXRot() != 0.0f && Math.abs(penguin.getXRot()) < 30.0f && penguin.isInWater() || penguin.onGround());
    }

    protected void start(Penguin penguin) {
        BrainUtils.setMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.IS_JUMPING, (Object)Unit.INSTANCE);
        Direction direction = penguin.getMotionDirection();
        penguin.setDeltaMovement(penguin.getDeltaMovement().add((double)direction.getStepX() * 0.6, 0.4, (double)direction.getStepZ() * 0.6));
    }

    protected void stop(Penguin penguin) {
        this.breached = false;
        penguin.setXRot(0.0f);
        penguin.setTimeAllowedToWaterJump(Optional.of(Mth.randomBetweenInclusive((RandomSource)penguin.getRandom(), (int)400, (int)600)));
        BrainUtils.clearMemories((LivingEntity)penguin, (MemoryModuleType[])new MemoryModuleType[]{RockhoppersMemoryModuleTypes.IS_JUMPING});
    }

    public void tick(Penguin penguin) {
        boolean breached = this.breached;
        if (!breached) {
            FluidState fluidState = penguin.level().getFluidState(penguin.blockPosition());
            this.breached = fluidState.is(FluidTags.WATER);
        }
        if (this.breached && !breached) {
            penguin.playSound(penguin.getWaterJumpSound(), 1.0f, 1.0f);
        }
        Vec3 movement = penguin.getDeltaMovement();
        if (movement.y < 0.0 && penguin.getXRot() != 0.0f) {
            penguin.setXRot(Mth.rotLerp((float)0.2f, (float)penguin.getXRot(), (float)0.0f));
        } else if (movement.length() > (double)1.0E-5f) {
            double horizontalDistance = movement.horizontalDistance();
            double atan2 = Math.atan2(-movement.y, horizontalDistance) * 180.0 / 3.1415927410125732;
            penguin.setXRot((float)atan2);
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_PRESENT));
    }
}

