/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.BoatPenguinsAttachment;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class LeaveBoat
extends ExtendedBehaviour<Penguin> {
    private Vec3 leavingBoatPos = null;

    public LeaveBoat() {
        this.runFor(penguin -> 200);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of(RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW, (Object)MemoryStatus.VALUE_PRESENT), Pair.of(RockhoppersMemoryModuleTypes.HUNGRY_TIME, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryStatus.VALUE_ABSENT));
    }

    public boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        if (penguin.tickCount < (Integer)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.HUNGRY_TIME) && penguin.getBoatToFollow() != null && (double)penguin.getBoatToFollow().distanceTo((Entity)penguin) <= 24.0) {
            return false;
        }
        this.leavingBoatPos = penguin.getBoatToFollow() == null ? penguin.position() : penguin.getBoatToFollow().position();
        return true;
    }

    public boolean shouldKeepRunning(Penguin penguin) {
        return penguin.distanceToSqr(this.leavingBoatPos) < 1024.0;
    }

    protected void start(Penguin penguin) {
        if (penguin.getBoatToFollow() != null) {
            BoatPenguinsAttachment boatData = RapscallionsAndRockhoppers.getHelper().getBoatPenguinData(penguin.getBoatToFollow());
            boatData.removeFollowingPenguin(penguin.getUUID());
            if (boatData.getFollowingPenguins().isEmpty()) {
                RapscallionsAndRockhoppers.getHelper().removeBoatPenguinData(penguin.getBoatToFollow());
            }
        }
        BrainUtils.setMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW, null);
        BrainUtils.setMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER, null);
        Vec3 posAway = DefaultRandomPos.getPosAway((PathfinderMob)penguin, (int)36, (int)8, (Vec3)this.leavingBoatPos);
        if (posAway != null) {
            BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(posAway, 1.0f, 2));
        }
    }

    protected void stop(Penguin penguin) {
        if (penguin.position().distanceTo(this.leavingBoatPos) >= 32.0) {
            penguin.returnToHome();
        }
        this.leavingBoatPos = null;
    }
}

