/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersTags;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class JumpTowardsCatch
extends ExtendedBehaviour<Penguin> {
    private boolean breached;

    protected boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        return penguin.getTimeAllowedToEat() <= 0;
    }

    public boolean shouldKeepRunning(Penguin penguin) {
        double yMovement = penguin.getDeltaMovement().y();
        return !(yMovement * yMovement < (double)0.03f && penguin.getXRot() != 0.0f && Math.abs(penguin.getXRot()) < 30.0f && penguin.isInWater() || penguin.onGround());
    }

    protected void start(Penguin penguin) {
        BrainUtils.setMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.IS_JUMPING, (Object)Unit.INSTANCE);
        FishingHook hook = (FishingHook)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.CAUGHT_BOBBER);
        Vec3 movementVec = hook.position().subtract(penguin.position()).normalize();
        penguin.setDeltaMovement(penguin.getDeltaMovement().add(movementVec.x() * 0.8, 0.4, movementVec.z() * 0.8));
    }

    protected void stop(Penguin penguin) {
        this.breached = false;
        penguin.setXRot(0.0f);
        penguin.setTimeAllowedToWaterJump(Optional.of(Mth.randomBetweenInclusive((RandomSource)penguin.getRandom(), (int)400, (int)600)));
        BrainUtils.clearMemories((LivingEntity)penguin, (MemoryModuleType[])new MemoryModuleType[]{RockhoppersMemoryModuleTypes.IS_JUMPING, RockhoppersMemoryModuleTypes.CAUGHT_BOBBER});
    }

    public void tick(Penguin penguin) {
        boolean breached = this.breached;
        if (!breached) {
            FluidState fluidState = penguin.level().getFluidState(penguin.blockPosition());
            this.breached = fluidState.is(FluidTags.WATER);
        }
        if (this.breached && !breached) {
            penguin.playSound(penguin.getWaterJumpSound(), 1.0f, 1.0f);
        }
        if (penguin.getTimeAllowedToEat() <= 0) {
            Optional<ItemEntity> item = penguin.level().getEntitiesOfClass(ItemEntity.class, penguin.getBoundingBox().inflate(1.25), itemEntity -> itemEntity.getItem().is(RockhoppersTags.ItemTags.PENGUIN_FOOD)).stream().min(Comparator.comparing(arg_0 -> ((Penguin)penguin).distanceTo(arg_0)));
            if (item.isPresent()) {
                penguin.setHungryTime(Optional.of(2400));
                penguin.setTimeAllowedToEat(Optional.of(120));
                penguin.incrementFishEaten();
                BrainUtils.setMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.FED_BY, (Object)((FishingHook)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.CAUGHT_BOBBER)).getPlayerOwner().getUUID());
                item.get().discard();
            }
        }
        Vec3 movement = penguin.getDeltaMovement();
        if (movement.y * movement.y < (double)0.03f && penguin.getXRot() != 0.0f) {
            penguin.setXRot(Mth.rotLerp((float)0.2f, (float)penguin.getXRot(), (float)0.0f));
        } else if (movement.length() > (double)1.0E-5f) {
            double horizontalDistance = movement.horizontalDistance();
            double atan2 = Math.atan2(-movement.y, horizontalDistance) * 180.0 / 1.5707963705062866;
            penguin.setXRot((float)atan2);
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_PRESENT), Pair.of(RockhoppersMemoryModuleTypes.CAUGHT_BOBBER, (Object)MemoryStatus.VALUE_PRESENT));
    }
}

