/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class FollowBoat
extends ExtendedBehaviour<Penguin> {
    private Vec3 previousBoatPos = null;
    private boolean isSameTickAsStart = false;
    private int timeToRecalcPath;
    private float untilDistance;

    public FollowBoat untilDistance(float untilDistance) {
        this.untilDistance = untilDistance;
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of(RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT));
    }

    public boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        if (penguin.getBoatToFollow() == null) {
            return false;
        }
        if (this.previousBoatPos == null) {
            this.previousBoatPos = new Vec3(penguin.getBoatToFollow().position().x(), 0.0, penguin.getBoatToFollow().position().z());
        }
        boolean boatPosValue = (double)Mth.abs((float)((float)(this.previousBoatPos.x() - penguin.getBoatToFollow().position().x()))) > 0.05 || (double)Mth.abs((float)((float)(this.previousBoatPos.z() - penguin.getBoatToFollow().position().z()))) > 0.05;
        this.previousBoatPos = new Vec3(penguin.getBoatToFollow().position().x(), 0.0, penguin.getBoatToFollow().position().z());
        this.isSameTickAsStart = true;
        return boatPosValue;
    }

    public boolean shouldKeepRunning(Penguin penguin) {
        if (penguin.getBoatToFollow() == null) {
            return false;
        }
        if (this.isSameTickAsStart) {
            this.isSameTickAsStart = false;
            return true;
        }
        boolean boatPosValue = (double)Mth.abs((float)((float)(this.previousBoatPos.x() - penguin.getBoatToFollow().position().x()))) > 0.05 || (double)Mth.abs((float)((float)(this.previousBoatPos.z() - penguin.getBoatToFollow().position().z()))) > 0.05;
        this.previousBoatPos = new Vec3(penguin.getBoatToFollow().position().x(), 0.0, penguin.getBoatToFollow().position().z());
        return boatPosValue;
    }

    protected void start(Penguin penguin) {
        BrainUtils.clearMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET);
    }

    protected void tick(Penguin penguin) {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            Vec3 directionVec = penguin.getBoatToFollow().calculateViewVector(0.0f, penguin.getBoatToFollow().getYRot()).multiply((double)(-this.untilDistance), 1.0, (double)(-this.untilDistance));
            BlockPos boatPos = penguin.getBoatToFollow().blockPosition().offset((int)directionVec.x(), (int)directionVec.y(), (int)directionVec.z());
            boatPos = boatPos.offset(0, -2, 0);
            BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(boatPos, penguin.isInWater() ? 2.0f : 1.5f, 1));
        }
    }

    protected void stop(Penguin penguin) {
        this.previousBoatPos = null;
    }
}

