/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersLootTables;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSoundEvents;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class CoughUpRewards
extends DelayedBehaviour<Penguin> {
    Player playerToCoughFor = null;

    public CoughUpRewards(int delayTicks) {
        super(delayTicks);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), Pair.of(RockhoppersMemoryModuleTypes.FISH_EATEN, (Object)MemoryStatus.VALUE_PRESENT), Pair.of(RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR, (Object)MemoryStatus.VALUE_PRESENT));
    }

    public boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        Player player;
        Entity playerToCoughFor = level.getEntity((UUID)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR));
        if (playerToCoughFor instanceof Player && (player = (Player)playerToCoughFor).onGround()) {
            this.playerToCoughFor = player;
        }
        return penguin.onGround() && penguin.walkTime == 0 && !penguin.isEyeInFluid(FluidTags.WATER) && this.playerToCoughFor != null;
    }

    protected void doDelayedAction(Penguin penguin) {
        BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)this.playerToCoughFor, true));
        ResourceKey<LootTable> lootTableKey = BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER) && BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER) == this.playerToCoughFor.getUUID() ? RockhoppersLootTables.PENGUIN_COUGH_UP_TRAVEL : RockhoppersLootTables.PENGUIN_COUGH_UP_FEED;
        LootTable lootTable = penguin.level().getServer().reloadableRegistries().getLootTable(lootTableKey);
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)penguin.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)penguin).withParameter(LootContextParams.ORIGIN, (Object)penguin.position());
        LootParams params = builder.create(LootContextParamSets.GIFT);
        for (int i = 0; i < Math.min(penguin.getFishEaten(), 6); ++i) {
            lootTable.getRandomItems(params, stack -> BehaviorUtils.throwItem((LivingEntity)penguin, (ItemStack)stack, (Vec3)this.playerToCoughFor.position()));
        }
        penguin.playSound(RockhoppersSoundEvents.PENGUIN_COUGH, 0.8f, 0.9f + penguin.getRandom().nextFloat() * 0.2f);
    }

    protected void start(Penguin penguin) {
        BrainUtils.setMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.HUNGRY_TIME, (Object)2400);
        BrainUtils.setMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_EAT, (Object)120);
        penguin.setCoughTicks(0);
    }

    protected void stop(Penguin penguin) {
        this.playerToCoughFor = null;
        BrainUtils.clearMemories((LivingEntity)penguin, (MemoryModuleType[])new MemoryModuleType[]{RockhoppersMemoryModuleTypes.FED_BY, RockhoppersMemoryModuleTypes.FISH_EATEN, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR});
    }
}

