/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity.behaviour;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;

public class BreatheAir
extends ExtendedBehaviour<Penguin> {
    private BlockPosTracker targetPos;

    public BreatheAir() {
        this.runFor(penguin -> 260);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of(Pair.of((Object)((MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Penguin penguin) {
        if (penguin.getAirSupply() > 260) {
            return false;
        }
        Optional<BlockPos> optional = ((List)BrainUtils.memoryOrDefault((LivingEntity)penguin, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get()), List::of)).stream().filter(blockPosBlockStatePair -> ((BlockState)blockPosBlockStatePair.getSecond()).isAir()).map(Pair::getFirst).min(Comparator.comparing(pos -> penguin.blockPosition().distSqr((Vec3i)pos)));
        Vec3 targetPos = optional.map(BlockPos::getCenter).orElseGet(() -> {
            Vec3 penguinPos = penguin.position().add(0.0, 8.0, 0.0);
            if (penguin.level().getBlockState(BlockPos.containing((Position)penguinPos)).isAir()) {
                return penguinPos;
            }
            return BehaviorUtils.getRandomSwimmablePos((PathfinderMob)penguin, (int)6, (int)12);
        });
        if (targetPos != null) {
            this.targetPos = new BlockPosTracker(BlockPos.containing((Position)targetPos));
        }
        return this.targetPos != null;
    }

    protected boolean shouldKeepRunning(Penguin penguin) {
        return penguin.getAirSupply() <= 260;
    }

    protected void tick(Penguin penguin) {
        if (BrainUtils.getMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET) == null || ((WalkTarget)BrainUtils.getMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET)).getTarget() != this.targetPos) {
            BrainUtils.setMemory((LivingEntity)penguin, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)this.targetPos, 1.5f, 0));
        }
    }
}

