/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.block.entity.PenguinEggBlockEntity;
import house.greenhouse.rapscallionsandrockhoppers.entity.PenguinVariant;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.AmphibiousSetRandomSwimTarget;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.BreatheAir;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.CoughUpRewards;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.FollowBoat;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.JumpTowardsCatch;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.LeaveBoat;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.PenguinHungryStare;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.PenguinJump;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.PenguinPeck;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.PenguinShove;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.PenguinSitEgg;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.PenguinStumble;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.SitAtSurfaceOfWater;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.StayWithinBoat;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.StayWithinHome;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.SwimToFishingBobber;
import house.greenhouse.rapscallionsandrockhoppers.entity.behaviour.WalkToRewardedPlayer;
import house.greenhouse.rapscallionsandrockhoppers.entity.sensor.BoatToFollowSensor;
import house.greenhouse.rapscallionsandrockhoppers.entity.sensor.NearbyBobbersSensor;
import house.greenhouse.rapscallionsandrockhoppers.entity.sensor.NearbyEggSensor;
import house.greenhouse.rapscallionsandrockhoppers.entity.sensor.NearbyShoveableSensor;
import house.greenhouse.rapscallionsandrockhoppers.entity.sensor.NearbyWaterSensor;
import house.greenhouse.rapscallionsandrockhoppers.entity.sensor.PenguinAttackTargetSensor;
import house.greenhouse.rapscallionsandrockhoppers.entity.sensor.PenguinHomeSensor;
import house.greenhouse.rapscallionsandrockhoppers.entity.sensor.PlayerToCoughForSensor;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersActivities;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersBlocks;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersEntityTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSoundEvents;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersTags;
import house.greenhouse.rapscallionsandrockhoppers.util.RockhoppersResourceKeys;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Panic;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.AvoidEntity;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowTemptation;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.NearbyBlocksSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.ItemTemptingSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyAdultSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Penguin
extends Animal
implements SmartBrainOwner<Penguin> {
    public static final int STUMBLE_ANIMATION_LENGTH = 30;
    private static final int SWIM_EASE_OUT_ANIMATION_LENGTH = 40;
    public static final int GET_UP_ANIMATION_LENGTH = 40;
    public static final int SHOVE_ANIMATION_LENGTH = 40;
    public static final int PECK_ANIMATION_LENGTH = 40;
    public static final int COUGH_ANIMATION_LENGTH = 40;
    protected static final Ingredient TEMPTATION_ITEM = Ingredient.of(RockhoppersTags.ItemTags.PENGUIN_TEMPT_ITEMS);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> DATA_PREVIOUS_VARIANT = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> DATA_SHOCKED_TIME = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_COUGH_TICKS = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_PECK_TICKS = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_STUMBLE_TICKS = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_STUMBLE_TICKS_BEFORE_GETTING_UP = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_SHOVE_TICKS = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_STUMBLE_CHANCE = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SHOVE_CHANCE = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<String> DATA_EGG = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> IS_STARING_AT_PLAYER = SynchedEntityData.defineId(Penguin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState waddleAnimationState = new AnimationState();
    public final AnimationState shockArmAnimationState = new AnimationState();
    public final AnimationState waddleArmEaseInAnimationState = new AnimationState();
    public final AnimationState waddleArmEaseOutAnimationState = new AnimationState();
    public final AnimationState stumbleAnimationState = new AnimationState();
    public final AnimationState stumbleGroundAnimationState = new AnimationState();
    public final AnimationState stumbleFallingAnimationState = new AnimationState();
    public final AnimationState stumbleGetUpAnimationState = new AnimationState();
    public final AnimationState swimIdleAnimationState = new AnimationState();
    public final AnimationState swimAnimationState = new AnimationState();
    public final AnimationState swimEaseInAnimationState = new AnimationState();
    public final AnimationState swimEaseOutAnimationState = new AnimationState();
    public final AnimationState shoveAnimationState = new AnimationState();
    public final AnimationState peckAnimationState = new AnimationState();
    public final AnimationState coughUpAnimationState = new AnimationState();
    public final AnimationState stareAnimationState = new AnimationState();
    public int walkTime = 0;
    private boolean areAnimationsWater = false;
    private boolean animationArmState = false;
    private boolean animationSwimState = false;
    private long easeOutAnimTime = Long.MIN_VALUE;
    private long stopEaseOutAnimAt = Long.MIN_VALUE;
    private boolean previousStumbleValue = false;
    private boolean previousWaterValue = false;
    private boolean previousWaterMovementValue = false;
    public Vec3 previousBoatPos = Vec3.ZERO;

    public Penguin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new PenguinMoveControl();
        this.lookControl = new PenguinLookControl();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putFloat("stumble_chance", this.getStumbleChance());
        compoundTag.putFloat("shove_chance", this.getShoveChance());
        if (BrainUtils.hasMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.HOME)) {
            compoundTag.put("home", (Tag)GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((GlobalPos)BrainUtils.getMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.HOME))).getOrThrow(result -> {
                RapscallionsAndRockhoppers.LOG.error("Memory encoding error in penguin: {}", result);
                return null;
            }));
        }
        if (BrainUtils.hasMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW)) {
            compoundTag.putUUID("boat_to_follow", (UUID)BrainUtils.getMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW));
        }
        if (BrainUtils.hasMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER)) {
            compoundTag.putUUID("last_following_boat_controller", (UUID)BrainUtils.getMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER));
        }
        if (BrainUtils.hasMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR)) {
            compoundTag.putUUID("player_to_cough_for", (UUID)BrainUtils.getMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR));
        }
        if (BrainUtils.hasMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_FOLLOW_BOAT)) {
            compoundTag.putInt("time_allowed_to_follow_boat", ((Integer)BrainUtils.getMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_FOLLOW_BOAT)).intValue());
        }
        if (BrainUtils.hasMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_WATER_JUMP)) {
            compoundTag.putInt("time_allowed_to_water_jump", ((Integer)BrainUtils.getMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_WATER_JUMP)).intValue());
        }
        if (BrainUtils.hasMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_EAT)) {
            compoundTag.putInt("time_allowed_to_eat", ((Integer)BrainUtils.getMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_EAT)).intValue());
        }
        if (BrainUtils.hasMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.HUNGRY_TIME)) {
            compoundTag.putInt("hungry_time", ((Integer)BrainUtils.getMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.HUNGRY_TIME)).intValue());
        }
        if (BrainUtils.hasMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.FISH_EATEN)) {
            compoundTag.putInt("fish_eaten", ((Integer)BrainUtils.getMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.FISH_EATEN)).intValue());
        }
        compoundTag.putString("variant", (String)this.getEntityData().get(DATA_VARIANT));
        if (!((String)this.getEntityData().get(DATA_PREVIOUS_VARIANT)).isEmpty()) {
            compoundTag.putString("previous_variant", (String)this.getEntityData().get(DATA_PREVIOUS_VARIANT));
        }
        if (!((String)this.getEntityData().get(DATA_EGG)).isEmpty()) {
            compoundTag.putString("egg", (String)this.getEntityData().get(DATA_EGG));
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setStumbleChance(compoundTag.getFloat("stumble_chance"));
        this.setShoveChance(compoundTag.getFloat("shove_chance"));
        if (compoundTag.contains("home", 10)) {
            BrainUtils.setMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.HOME, (Object)((GlobalPos)((Pair)GlobalPos.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.getCompound("home")).getOrThrow(result -> {
                RapscallionsAndRockhoppers.LOG.error("Memory decoding error in penguin: {}", result);
                return null;
            })).getFirst()));
        }
        if (compoundTag.contains("boat_to_follow")) {
            this.setBoatToFollow(compoundTag.getUUID("boat_to_follow"));
        } else {
            this.setBoatToFollow(null);
        }
        if (compoundTag.contains("last_following_boat_controller")) {
            BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER, (Object)compoundTag.getUUID("last_following_boat_controller"));
        } else {
            BrainUtils.clearMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.LAST_FOLLOWING_BOAT_CONTROLLER);
        }
        if (compoundTag.contains("player_to_cough_for")) {
            BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR, (Object)compoundTag.getUUID("player_to_cough_for"));
        } else {
            BrainUtils.clearMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR);
        }
        if (compoundTag.contains("time_allowed_to_follow_boat", 3)) {
            this.setTimeAllowedToFollowBoat(this.integerOptional(compoundTag.getInt("time_allowed_to_follow_boat")));
        }
        if (compoundTag.contains("time_allowed_to_water_jump", 3)) {
            this.setTimeAllowedToWaterJump(this.integerOptional(compoundTag.getInt("time_allowed_to_water_jump")));
        }
        if (compoundTag.contains("time_allowed_to_eat", 3)) {
            this.setTimeAllowedToEat(this.integerOptional(compoundTag.getInt("time_allowed_to_eat")));
        }
        if (compoundTag.contains("hungry_time", 3)) {
            this.setHungryTime(this.integerOptional(compoundTag.getInt("hungry_time")));
        }
        if (compoundTag.contains("fish_eaten", 3)) {
            this.setFishEaten(compoundTag.getInt("fish_eaten"));
        }
        if (compoundTag.contains("previous_variant")) {
            this.getEntityData().set(DATA_PREVIOUS_VARIANT, (Object)compoundTag.getString("previous_variant"));
        } else if (compoundTag.contains("previous_type")) {
            this.getEntityData().set(DATA_PREVIOUS_VARIANT, (Object)compoundTag.getString("previous_variant"));
        }
        if (compoundTag.contains("variant") || compoundTag.contains("type")) {
            ResourceLocation typeKey = ResourceLocation.tryParse((String)(compoundTag.contains("variant") ? compoundTag.getString("variant") : compoundTag.getString("type")));
            Optional variant = typeKey == null ? Optional.empty() : this.level().registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getHolder(typeKey);
            variant.ifPresent(this::setVariant);
        }
        if (compoundTag.contains("egg") && ResourceLocation.tryParse((String)compoundTag.getString("egg")) != null) {
            this.setEggPenguinType(compoundTag.getString("egg"));
        }
    }

    private Optional<Integer> integerOptional(int value) {
        if (value == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    @NotNull
    protected Brain.Provider<Penguin> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<Penguin>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new BoatToFollowSensor().setUpdatePenguinRadius(9.0, 6.0).setRadius(32.0), new PenguinHomeSensor(), new NearbyShoveableSensor(), new NearbyBlocksSensor().setRadius(4.0, 5.0).setPredicate((blockState, penguin) -> blockState.isAir()), new NearbyLivingEntitySensor().setRadius(16.0), new NearbyPlayersSensor().setRadius(16.0), new NearbyAdultSensor(), new NearbyWaterSensor().setXZRadius(8).setYRadius(4), new PenguinAttackTargetSensor(), new ItemTemptingSensor().temptedWith((entity, stack) -> TEMPTATION_ITEM.test(stack)), new InWaterSensor().setPredicate((entity, entity2) -> entity.isInWaterOrBubble() || BrainUtils.hasMemory((LivingEntity)entity, RockhoppersMemoryModuleTypes.IS_JUMPING)), new HurtBySensor(), new NearbyEggSensor(), new PlayerToCoughForSensor(), new NearbyBobbersSensor()});
    }

    public BrainActivityGroup<Penguin> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<Penguin> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new Panic().speedMod(o -> 2.5f).panicIf((mob, damageSource) -> mob.isFreezing() || mob.isOnFire() || damageSource.getEntity() instanceof LivingEntity || this.isShocked()), new BreedWithPartner(), new SetPlayerLookTarget(), new SetRandomLookTarget().lookChance((FloatProvider)ConstantFloat.of((float)0.6f)), new PenguinSitEgg().startCondition(penguin -> !penguin.isBaby()).runFor(penguin -> penguin.random.nextInt(3600, 9000)).cooldownFor(penguin -> 1000), new StayWithinHome().setRadius(8).startCondition(penguin -> !penguin.isStumbling() && penguin.getBoatToFollow() == null), new SetAttackTarget().attackPredicate(penguin -> BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.HUNGRY_TIME) && (Integer)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.HUNGRY_TIME) <= 0), new PenguinPeck(8), new PenguinShove(), new PenguinStumble(), new FollowBoat().untilDistance(1.5f), new StayWithinBoat().setRadius(4), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new FollowTemptation(), new SetWalkTargetToAttackTarget(), new PenguinHungryStare().startCondition(penguin -> penguin.getHungryTime() > 600).runFor(penguin -> penguin.random.nextInt(250, 600)), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new SetRandomWalkTarget().setRadius(4.0, 3.0).avoidWaterWhen(penguin -> penguin.getRandom().nextFloat() > 0.06f), (Object)9), Pair.of((Object)new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60)), (Object)1)})})}).onlyStartWithMemoryStatus(MemoryModuleType.IS_IN_WATER, MemoryStatus.VALUE_ABSENT);
    }

    public Map<Activity, BrainActivityGroup<? extends Penguin>> getAdditionalTasks() {
        return Map.of(Activity.SWIM, new BrainActivityGroup(Activity.SWIM).priority(10).behaviours(new Behavior[]{new BreatheAir(), new Panic().panicIf((mob, damageSource) -> mob.isFreezing() || mob.isOnFire() || damageSource.getEntity() instanceof LivingEntity || this.isShocked()), new BreedWithPartner(), new StayWithinHome().setRadius(12), new SetAttackTarget().attackPredicate(penguin -> BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.HUNGRY_TIME) && penguin.tickCount > (Integer)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.HUNGRY_TIME) - 300), new PenguinPeck(8), new AvoidEntity().avoiding(entity -> entity instanceof Pufferfish), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new FollowTemptation(), new SetWalkTargetToAttackTarget().startCondition(penguin -> penguin.getAirSupply() >= 260), new PenguinJump(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AmphibiousSetRandomSwimTarget().moveToLandWhen(penguin -> penguin.getRandom().nextFloat() < 0.06f).setRadius(5.0, 4.0).walkTargetPredicate((mob, vec3) -> vec3 == null || mob.level().getEntities(EntityTypeTest.forClass(Boat.class), mob.getBoundingBox().move(vec3.subtract(mob.position())).inflate(3.0, 2.0, 3.0), boat -> true).isEmpty()), (Object)19), Pair.of((Object)new Idle().runFor(entity -> entity.getRandom().nextInt(30, 60)), (Object)1)})})}).onlyStartWithMemoryStatus(MemoryModuleType.IS_IN_WATER, MemoryStatus.VALUE_PRESENT), RockhoppersActivities.FOLLOW_BOAT, new BrainActivityGroup(RockhoppersActivities.FOLLOW_BOAT).priority(20).behaviours(new Behavior[]{new BreatheAir(), new LeaveBoat(), new FollowBoat().untilDistance(2.0f).runFor(penguin -> 200), new Panic().panicIf((mob, damageSource) -> mob.isFreezing() || mob.isOnFire() || damageSource.getEntity() instanceof LivingEntity || this.isShocked()), new SetAttackTarget().attackPredicate(penguin -> {
            if (!BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.HUNGRY_TIME) || penguin.getAirSupply() < 260) {
                return false;
            }
            if (!(penguin.getBoatToFollow() == null || BrainUtils.hasMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_EAT) && (Integer)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_EAT) >= 0)) {
                boolean bl = penguin.previousBoatPos.subtract(penguin.getBoatToFollow().position()).horizontalDistance() > 0.075;
                penguin.previousBoatPos = penguin.getBoatToFollow().position();
                return bl;
            }
            return (Integer)BrainUtils.getMemory((LivingEntity)penguin, RockhoppersMemoryModuleTypes.HUNGRY_TIME) > 0;
        }), new PenguinPeck(8), new BreedWithPartner(), new AvoidEntity().avoiding(entity -> entity instanceof Pufferfish), new StayWithinBoat().setRadius(8), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new FollowTemptation(), new SetWalkTargetToAttackTarget().startCondition(penguin -> penguin.getAirSupply() >= 260), new PenguinJump(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AmphibiousSetRandomSwimTarget().setRadius(6.0, 4.0).startCondition(penguin -> penguin.getBoatToFollow() != null && penguin.getBoatToFollow().getDeltaMovement().horizontalDistanceSqr() < 0.05), (Object)19), Pair.of((Object)new Idle().runFor(entity -> entity.getRandom().nextInt(15, 30)), (Object)1)})})}).onlyStartWithMemoryStatus(MemoryModuleType.IS_IN_WATER, MemoryStatus.VALUE_PRESENT).onlyStartWithMemoryStatus(RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW, MemoryStatus.VALUE_PRESENT), RockhoppersActivities.COUGH_UP, new BrainActivityGroup(RockhoppersActivities.COUGH_UP).priority(30).behaviours(new Behavior[]{new BreatheAir(), new WalkToRewardedPlayer(), new FollowTemptation(), new CoughUpRewards(8)}).onlyStartWithMemoryStatus(RockhoppersMemoryModuleTypes.FISH_EATEN, MemoryStatus.VALUE_PRESENT).onlyStartWithMemoryStatus(RockhoppersMemoryModuleTypes.PLAYER_TO_COUGH_FOR, MemoryStatus.VALUE_PRESENT).onlyStartWithMemoryStatus(MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT), RockhoppersActivities.WAIT_AROUND_BOBBER, new BrainActivityGroup(RockhoppersActivities.WAIT_AROUND_BOBBER).priority(30).behaviours(new Behavior[]{new SitAtSurfaceOfWater(), new SwimToFishingBobber().setRadius(3), new JumpTowardsCatch()}).onlyStartWithMemoryStatus(RockhoppersMemoryModuleTypes.NEAREST_BOBBERS, MemoryStatus.VALUE_PRESENT).onlyStartWithMemoryStatus(MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT));
    }

    public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{RockhoppersActivities.COUGH_UP, RockhoppersActivities.WAIT_AROUND_BOBBER, RockhoppersActivities.FOLLOW_BOAT, Activity.SWIM, Activity.IDLE});
    }

    public int getFishEaten() {
        return (Integer)BrainUtils.memoryOrDefault((LivingEntity)this, RockhoppersMemoryModuleTypes.FISH_EATEN, () -> 0);
    }

    public void setFishEaten(int fishEatenValue) {
        BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.FISH_EATEN, (Object)fishEatenValue);
    }

    public void incrementFishEaten() {
        BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.FISH_EATEN, (Object)((Integer)BrainUtils.memoryOrDefault((LivingEntity)this, RockhoppersMemoryModuleTypes.FISH_EATEN, () -> 0) + 1));
    }

    public void setTimeAllowedToWaterJump(Optional<Integer> waterJumpCooldownTicks) {
        BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_WATER_JUMP, (Object)waterJumpCooldownTicks.orElse(null));
    }

    public int getTimeAllowedToWaterJump() {
        return (Integer)BrainUtils.memoryOrDefault((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_WATER_JUMP, () -> 0);
    }

    public void setTimeAllowedToEat(Optional<Integer> eatTicks) {
        BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_EAT, (Object)eatTicks.orElse(null));
    }

    public int getTimeAllowedToEat() {
        return (Integer)BrainUtils.memoryOrDefault((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_EAT, () -> 0);
    }

    public void setHungryTime(Optional<Integer> leaveTime) {
        BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.HUNGRY_TIME, (Object)leaveTime.orElse(null));
    }

    public int getHungryTime() {
        return (Integer)BrainUtils.memoryOrDefault((LivingEntity)this, RockhoppersMemoryModuleTypes.HUNGRY_TIME, () -> 0);
    }

    public void setTimeAllowedToFollowBoat(Optional<Integer> boatFollowCooldownTicks) {
        BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_FOLLOW_BOAT, (Object)boatFollowCooldownTicks.orElse(null));
    }

    public int getTimeAllowedToFollowBoat() {
        return (Integer)BrainUtils.memoryOrDefault((LivingEntity)this, RockhoppersMemoryModuleTypes.TIME_ALLOWED_TO_FOLLOW_BOAT, () -> 0);
    }

    public void setBoatToFollow(@Nullable UUID boatUuid) {
        BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW, (Object)boatUuid);
    }

    public Boat getBoatToFollow() {
        Entity entity;
        if (!this.level().isClientSide() && (entity = ((ServerLevel)this.level()).getEntity((UUID)BrainUtils.getMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW))) instanceof Boat) {
            Boat boat = (Boat)entity;
            return boat;
        }
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)"rapscallionsandrockhoppers:rockhopper");
        builder.define(DATA_PREVIOUS_VARIANT, (Object)"");
        builder.define(DATA_STUMBLE_CHANCE, (Object)Float.valueOf(0.0f));
        builder.define(DATA_STUMBLE_TICKS, (Object)Integer.MIN_VALUE);
        builder.define(DATA_STUMBLE_TICKS_BEFORE_GETTING_UP, (Object)Integer.MIN_VALUE);
        builder.define(DATA_SHOVE_CHANCE, (Object)Float.valueOf(0.0f));
        builder.define(DATA_SHOVE_TICKS, (Object)Integer.MIN_VALUE);
        builder.define(DATA_SHOCKED_TIME, (Object)0);
        builder.define(DATA_PECK_TICKS, (Object)Integer.MIN_VALUE);
        builder.define(DATA_EGG, (Object)"");
        builder.define(DATA_COUGH_TICKS, (Object)Integer.MIN_VALUE);
        builder.define(IS_STARING_AT_PLAYER, (Object)false);
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
        super.customServerAiStep();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(RockhoppersTags.ItemTags.PENGUIN_FOOD)) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (this.getTimeAllowedToEat() <= 0) {
                if (!this.level().isClientSide) {
                    this.setHungryTime(Optional.of(2400));
                    this.setTimeAllowedToEat(Optional.of(120));
                    this.incrementFishEaten();
                    BrainUtils.setMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.FED_BY, (Object)player.getUUID());
                    stack.consume(1, (LivingEntity)player);
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(0.5), this.getRandomY() + 0.5, this.getRandomZ(0.5), 7, 0.25, 0.1, 0.25, 0.0);
                    this.playSound(RockhoppersSoundEvents.PENGUIN_EAT);
                    return InteractionResult.SUCCESS;
                }
            } else {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(0.5), this.getRandomY() + 0.5, this.getRandomZ(0.5), 7, 0.25, 0.1, 0.25, 0.0);
                return InteractionResult.CONSUME;
            }
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        super.tick();
        if (this.isNoAi()) {
            this.setAirSupply(this.getMaxAirSupply());
            return;
        }
        if (!this.previousWaterValue && this.isInWater() && this.getVehicle() == null) {
            this.setPose(Pose.SWIMMING);
            if (!this.level().isClientSide()) {
                this.setTimeAllowedToWaterJump(Optional.of(Mth.randomBetweenInclusive((RandomSource)this.getRandom(), (int)200, (int)400)));
            }
            this.previousWaterValue = true;
        } else if (this.previousWaterValue && (!this.isInWater() && this.onGround() || this.getVehicle() != null)) {
            this.setPose(Pose.STANDING);
            this.previousWaterValue = false;
        }
        if (!this.level().isClientSide()) {
            if (this.walkAnimation.isMoving()) {
                this.walkTime = 20;
            }
            if (this.walkTime > 0) {
                --this.walkTime;
            }
            if (this.isShocked()) {
                this.setShockedTime(this.getShockedTime() - 1);
            }
            if (this.isPecking()) {
                if (this.getPeckTicks() > 40) {
                    this.setPeckTicks(Integer.MIN_VALUE);
                } else {
                    this.setPeckTicks(this.getPeckTicks() + 1);
                }
            }
            if (this.isCoughingUpItems()) {
                if (this.getCoughTicks() > 40) {
                    this.setCoughTicks(Integer.MIN_VALUE);
                } else {
                    this.setCoughTicks(this.getCoughTicks() + 1);
                }
            }
            if (this.getShoveTicks() != Integer.MIN_VALUE) {
                if (this.getShoveTicks() < 0) {
                    this.setShoveTicks(Integer.MIN_VALUE);
                } else {
                    int previousValue = this.getShoveTicks();
                    this.setShoveTicks(previousValue - 1);
                }
            }
            if (this.getHungryTime() > 0) {
                this.setHungryTime(Optional.of(this.getHungryTime() - 1));
            }
            if (this.getTimeAllowedToEat() > 0) {
                this.setTimeAllowedToEat(Optional.of(this.getTimeAllowedToEat() - 1));
            }
            if (this.getTimeAllowedToWaterJump() > 0) {
                this.setTimeAllowedToWaterJump(Optional.of(this.getTimeAllowedToWaterJump() - 1));
            }
            if (this.getTimeAllowedToFollowBoat() > 0) {
                this.setTimeAllowedToFollowBoat(Optional.of(this.getHungryTime() - 1));
            }
            if (this.hasEgg() && this.onGround() && !this.isStumbling() && this.getPose() == Pose.STANDING && this.level().getBlockState(this.blockPosition()).isAir() && this.getBlockStateOn().isFaceSturdy((BlockGetter)this.level(), this.blockPosition(), this.getDirection()) && !this.level().getBlockState(this.blockPosition().below()).isAir()) {
                this.level().setBlockAndUpdate(this.blockPosition(), RockhoppersBlocks.PENGUIN_EGG.defaultBlockState());
                BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
                if (blockEntity instanceof PenguinEggBlockEntity) {
                    PenguinEggBlockEntity penguinEggBlockEntity = (PenguinEggBlockEntity)blockEntity;
                    penguinEggBlockEntity.setPenguinVariant(this.getEggType());
                }
                this.setEggPenguinType("");
            }
        } else {
            this.peckAnimationState.animateWhen(this.isPecking(), this.tickCount);
            if (this.getPose() == Pose.SWIMMING) {
                if (!this.areAnimationsWater) {
                    this.stopAllLandAnimations();
                    this.areAnimationsWater = true;
                }
                this.swimIdleAnimationState.animateWhen(!this.walkAnimation.isMoving(), this.tickCount);
                this.swimAnimationState.animateWhen(this.walkAnimation.isMoving(), this.tickCount);
                if (!this.animationSwimState && this.walkAnimation.isMoving()) {
                    this.swimEaseOutAnimationState.stop();
                    this.swimEaseInAnimationState.startIfStopped(this.tickCount);
                    this.animationSwimState = true;
                } else if (this.animationSwimState && !this.walkAnimation.isMoving()) {
                    this.swimEaseInAnimationState.stop();
                    this.swimEaseOutAnimationState.startIfStopped(this.tickCount);
                    this.animationSwimState = false;
                }
            } else {
                if (this.areAnimationsWater) {
                    this.stopAllWaterAnimations();
                    this.areAnimationsWater = false;
                }
                this.coughUpAnimationState.animateWhen(this.isCoughingUpItems(), this.tickCount);
                if (this.easeOutAnimTime > this.stopEaseOutAnimAt) {
                    this.swimEaseOutAnimationState.stop();
                    this.easeOutAnimTime = Integer.MIN_VALUE;
                    this.stopEaseOutAnimAt = Integer.MIN_VALUE;
                }
                if (this.easeOutAnimTime != Integer.MIN_VALUE) {
                    ++this.easeOutAnimTime;
                }
                this.stareAnimationState.animateWhen(!this.walkAnimation.isMoving() && !this.isStumbling() && this.shouldStare(), this.tickCount);
                this.idleAnimationState.animateWhen(!this.walkAnimation.isMoving() && !this.isStumbling() && !this.shouldStare(), this.tickCount);
                this.waddleAnimationState.animateWhen(this.walkAnimation.isMoving() && !this.isStumbling(), this.tickCount);
                this.shockArmAnimationState.animateWhen(this.isShocked() && !this.isStumbling() && !this.isDeadOrDying(), this.tickCount);
                if (this.isStumbling()) {
                    this.stumbleFallingAnimationState.animateWhen(this.getDeltaMovement().y() < -0.1, this.tickCount);
                    if (!this.previousStumbleValue) {
                        this.waddleArmEaseOutAnimationState.stop();
                        this.waddleArmEaseInAnimationState.stop();
                        this.stumbleAnimationState.start(this.tickCount);
                        this.animationArmState = false;
                        this.previousStumbleValue = true;
                    }
                    if (this.getStumbleTicksBeforeGettingUp() != Integer.MIN_VALUE && this.getStumbleTicks() > 30) {
                        this.stumbleAnimationState.stop();
                        this.stumbleGroundAnimationState.animateWhen(!this.isGettingUp(), this.tickCount);
                        this.stumbleGetUpAnimationState.animateWhen(this.isGettingUp(), this.tickCount);
                    }
                } else if (!this.isStumbling() && this.previousStumbleValue) {
                    this.stumbleAnimationState.stop();
                    this.stumbleGroundAnimationState.stop();
                    this.stumbleGetUpAnimationState.stop();
                    this.stumbleFallingAnimationState.stop();
                    this.previousStumbleValue = false;
                } else {
                    this.shoveAnimationState.animateWhen(this.getShoveTicks() != Integer.MIN_VALUE, this.tickCount);
                    if (!this.animationArmState && this.walkAnimation.isMoving()) {
                        this.waddleArmEaseOutAnimationState.stop();
                        this.waddleArmEaseInAnimationState.startIfStopped(this.tickCount);
                        this.animationArmState = true;
                    } else if (this.animationArmState && !this.walkAnimation.isMoving()) {
                        this.waddleArmEaseInAnimationState.stop();
                        this.waddleArmEaseOutAnimationState.startIfStopped(this.tickCount);
                        this.animationArmState = false;
                    }
                }
            }
        }
        this.refreshDimensionsIfShould();
    }

    public double getFluidJumpThreshold() {
        return this.isSwimming() ? 0.0 : super.getFluidJumpThreshold();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void returnToHome() {
        GlobalPos home = (GlobalPos)BrainUtils.getMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.HOME);
        if (home != null && this.level().dimension() == home.dimension() && this.blockPosition().distSqr((Vec3i)home.pos()) > 1024.0) {
            int i;
            ServerLevel serverLevel;
            BlockPos randomPos = null;
            int xSection = SectionPos.blockToSectionCoord((int)home.pos().getX());
            int zSection = SectionPos.blockToSectionCoord((int)home.pos().getZ());
            Level level = this.level();
            if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getChunk(xSection, zSection, ChunkStatus.FULL, true) == null) {
                RapscallionsAndRockhoppers.loadNearbyChunks(home.pos(), serverLevel);
            }
            for (i = 0; i < 10; ++i) {
                randomPos = this.getRandomPos(home.pos());
                if (!this.level().getBlockState(randomPos).isPathfindable(PathComputationType.WATER)) break;
            }
            if (!this.level().getBlockState(randomPos).isPathfindable(PathComputationType.WATER)) {
                randomPos = null;
            }
            if (randomPos == null) {
                randomPos = home.pos();
                for (i = 0; i < 10; ++i) {
                    randomPos = home.pos().above();
                    if (!this.level().getBlockState(randomPos).isPathfindable(PathComputationType.LAND)) break;
                }
            }
            this.teleportTo(randomPos.getX(), randomPos.getY(), randomPos.getZ());
            level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel2 = (ServerLevel)level;
                RapscallionsAndRockhoppers.unloadChunks(serverLevel2);
            }
        }
    }

    private BlockPos getRandomPos(BlockPos home) {
        int xOffset = this.getRandom().nextIntBetweenInclusive(8, 12);
        int zOffset = this.getRandom().nextIntBetweenInclusive(8, 12);
        if (this.getRandom().nextBoolean()) {
            xOffset = -xOffset;
        }
        if (this.getRandom().nextBoolean()) {
            zOffset = -zOffset;
        }
        return new BlockPos(home.getX() + xOffset, home.getY(), home.getZ() + zOffset);
    }

    public int getTotalStumbleAnimationLength() {
        if (this.getStumbleTicksBeforeGettingUp() == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return 30 + this.getStumbleTicksBeforeGettingUp() + 40;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        if (spawnType != MobSpawnType.STRUCTURE) {
            if (data == null) {
                data = new PenguinGroupData();
            }
            this.setVariant(((PenguinGroupData)((Object)data)).getSpawnVariant(this.blockPosition(), level, level.getRandom()));
            this.setStumbleChance(Mth.randomBetween((RandomSource)this.getRandom(), (float)0.0025f, (float)0.005f));
            this.setShoveChance(Mth.randomBetween((RandomSource)this.getRandom(), (float)0.001f, (float)0.0025f));
        }
        return super.finalizeSpawn(level, difficulty, spawnType, data);
    }

    public static boolean checkPenguinSpawnRules(EntityType<? extends Penguin> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        return Penguin.getTotalSpawnWeight(level, pos) > 0 && Animal.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public static int getTotalSpawnWeight(LevelAccessor level, BlockPos pos) {
        int totalWeight = 0;
        for (PenguinVariant variant : level.registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT)) {
            if (!variant.biomes().unwrap().stream().anyMatch(pt -> ((HolderSet)pt.data()).contains(level.getBiome(pos)) && pt.weight().asInt() > 0)) continue;
            totalWeight += variant.biomes().unwrap().stream().map(holderSetWrapper -> holderSetWrapper.weight().asInt()).reduce(Integer::sum).orElse(0).intValue();
        }
        return totalWeight;
    }

    public void spawnChildFromBreeding(ServerLevel level, Animal animal) {
        boolean cancelled = RapscallionsAndRockhoppers.getHelper().runAndIsBreedEventCancelled(this, animal);
        if (cancelled) {
            this.setAge(6000);
            animal.setAge(6000);
            this.resetLove();
            animal.resetLove();
        } else {
            Holder<PenguinVariant> pickedEggType = this.random.nextBoolean() ? this.getTrueType() : ((Penguin)animal).getTrueType();
            this.setEggPenguinType(pickedEggType.toString());
            this.finalizeSpawnChildFromBreeding(level, animal, null);
        }
    }

    public boolean canRide(Entity vehicle) {
        if (vehicle instanceof Boat) {
            return !BrainUtils.hasMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.IS_IN_WATER) && !BrainUtils.hasMemory((LivingEntity)this, RockhoppersMemoryModuleTypes.BOAT_TO_FOLLOW);
        }
        return true;
    }

    public int getMaxHeadXRot() {
        return 15;
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    protected int increaseAirSupply(int value) {
        return super.increaseAirSupply(this.getMaxAirSupply());
    }

    protected PathNavigation createNavigation(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        Penguin baby = (Penguin)RockhoppersEntityTypes.PENGUIN.create((Level)level);
        if (baby != null) {
            if (this.getRandom().nextBoolean()) {
                baby.setFromParent((Penguin)ageableMob);
            } else {
                baby.setFromParent(this);
            }
        }
        return baby;
    }

    protected void setFromParent(Penguin penguin) {
        Registry registry = this.level().registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT);
        if (!((String)penguin.getEntityData().get(DATA_PREVIOUS_VARIANT)).isEmpty()) {
            try {
                Optional variant = registry.getHolder(ResourceLocation.tryParse((String)((String)penguin.getEntityData().get(DATA_PREVIOUS_VARIANT))));
                variant.ifPresent(this::setVariant);
            }
            catch (Exception ex) {
                RapscallionsAndRockhoppers.LOG.error("Failed to set penguin from parent: ", (Throwable)ex);
            }
            return;
        }
        try {
            Optional variant = registry.getHolder(ResourceLocation.tryParse((String)((String)penguin.getEntityData().get(DATA_VARIANT))));
            variant.ifPresent(this::setVariant);
        }
        catch (Exception ex) {
            RapscallionsAndRockhoppers.LOG.error("Failed to set penguin from parent: ", (Throwable)ex);
        }
    }

    public SoundEvent getAmbientSound() {
        Optional<Holder<SoundEvent>> soundEventHolder = ((PenguinVariant)this.getVariant().value()).sounds().ambientSound();
        if (soundEventHolder.isPresent() && soundEventHolder.get().isBound()) {
            return (SoundEvent)soundEventHolder.get().value();
        }
        return SoundEvents.EMPTY;
    }

    public SoundEvent getHurtSound(DamageSource damageSource) {
        Optional<Holder<SoundEvent>> soundEventHolder = ((PenguinVariant)this.getVariant().value()).sounds().hurtSound();
        if (soundEventHolder.isPresent() && soundEventHolder.get().isBound()) {
            return (SoundEvent)soundEventHolder.get().value();
        }
        return SoundEvents.EMPTY;
    }

    public SoundEvent getDeathSound() {
        Optional<Holder<SoundEvent>> soundEventHolder = ((PenguinVariant)this.getVariant().value()).sounds().deathSound();
        if (soundEventHolder.isPresent() && soundEventHolder.get().isBound()) {
            return (SoundEvent)soundEventHolder.get().value();
        }
        return SoundEvents.EMPTY;
    }

    public SoundEvent getWaterJumpSound() {
        Optional<Holder<SoundEvent>> soundEventHolder = ((PenguinVariant)this.getVariant().value()).sounds().waterJumpSound();
        if (soundEventHolder.isPresent() && soundEventHolder.get().isBound()) {
            return (SoundEvent)soundEventHolder.get().value();
        }
        return SoundEvents.EMPTY;
    }

    public Holder<PenguinVariant> getVariant() {
        return (Holder)this.level().registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getHolder(ResourceLocation.tryParse((String)((String)this.getEntityData().get(DATA_VARIANT)))).orElse(this.level().registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getHolderOrThrow(RockhoppersResourceKeys.PenguinVariantKeys.ROCKHOPPER));
    }

    public void setCustomName(@Nullable Component name) {
        this.onNameChange(name);
        super.setCustomName(name);
    }

    public void setVariant(Holder<PenguinVariant> value) {
        this.getEntityData().set(DATA_VARIANT, (Object)((ResourceKey)value.unwrapKey().orElseThrow()).location().toString());
        if (value.isBound() && ((PenguinVariant)value.value()).whenNamed().isEmpty()) {
            this.getEntityData().set(DATA_PREVIOUS_VARIANT, (Object)"");
        }
        if (value.isBound()) {
            this.getAttribute(Attributes.SCALE).setBaseValue((double)((PenguinVariant)value.value()).size());
        }
    }

    public void onNameChange(Component newName) {
        Optional previous;
        Registry registry = this.level().registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT);
        Optional<Holder.Reference> nameReference = registry.holders().filter(penguinType -> ((PenguinVariant)penguinType.value()).whenNamed().isPresent() && newName != null && ((PenguinVariant)penguinType.value()).whenNamed().get().equals(ChatFormatting.stripFormatting((String)newName.getString()))).findFirst();
        if (nameReference.isPresent()) {
            if (((String)this.getEntityData().get(DATA_PREVIOUS_VARIANT)).isEmpty()) {
                this.getEntityData().set(DATA_PREVIOUS_VARIANT, (Object)((String)this.getEntityData().get(DATA_VARIANT)));
            }
            this.setVariant((Holder<PenguinVariant>)((Holder)nameReference.get()));
        } else if (!((String)this.getEntityData().get(DATA_PREVIOUS_VARIANT)).isEmpty() && (previous = registry.getHolder(ResourceLocation.tryParse((String)((String)this.getEntityData().get(DATA_PREVIOUS_VARIANT))))).isPresent()) {
            this.setVariant((Holder<PenguinVariant>)((Holder)previous.get()));
            this.getEntityData().set(DATA_PREVIOUS_VARIANT, (Object)"");
        }
    }

    protected int getBaseExperienceReward() {
        return 0;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(RockhoppersTags.ItemTags.PENGUIN_BREED_ITEMS);
    }

    public void refreshDimensionsIfShould() {
        if (this.isInWater() && this.previousWaterMovementValue ^ this.getPose() == Pose.SWIMMING) {
            this.previousWaterMovementValue = !this.previousWaterMovementValue;
            this.refreshDimensions();
        } else if (this.isStumbling() && this.getStumbleTicksBeforeGettingUp() != Integer.MIN_VALUE && (this.getStumbleTicks() == 32 || this.getStumbleTicks() == this.getStumbleTicksBeforeGettingUp() + 5)) {
            this.refreshDimensions();
        }
    }

    public void travel(Vec3 vec3) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), vec3);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(vec3);
        }
    }

    private void stopAllLandAnimations() {
        this.idleAnimationState.stop();
        this.waddleAnimationState.stop();
        this.waddleArmEaseInAnimationState.stop();
        this.waddleArmEaseOutAnimationState.stop();
        this.shockArmAnimationState.stop();
        this.stumbleAnimationState.stop();
        this.stumbleFallingAnimationState.stop();
        this.stumbleGroundAnimationState.stop();
        this.stumbleGetUpAnimationState.stop();
        this.stareAnimationState.stop();
        this.animationArmState = false;
    }

    private void stopAllWaterAnimations() {
        this.swimIdleAnimationState.stop();
        this.swimAnimationState.stop();
        if (this.walkAnimation.isMoving()) {
            this.swimEaseOutAnimationState.startIfStopped(this.tickCount);
            this.stopEaseOutAnimAt = this.tickCount + 40;
        }
        this.swimEaseInAnimationState.stop();
        this.animationSwimState = false;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.getStumbleTicksBeforeGettingUp() != Integer.MIN_VALUE && this.getStumbleTicks() >= 32 && this.getStumbleTicks() < this.getStumbleTicksBeforeGettingUp() + 5) {
            return super.getDefaultDimensions(pose).scale(1.0f, 0.5f);
        }
        if (this.getPose() == Pose.SWIMMING) {
            return super.getDefaultDimensions(pose).scale(1.0f, 0.7f);
        }
        return super.getDefaultDimensions(pose);
    }

    protected void actuallyHurt(DamageSource damageSource, float amount) {
        super.actuallyHurt(damageSource, amount);
        this.setShockedTime(this.random.nextInt(60, 120));
        this.setShoveTicks(Integer.MIN_VALUE);
        this.setStumbleTicks(Integer.MIN_VALUE);
        if (this.getHungryTime() > 0) {
            this.setHungryTime(this.integerOptional(this.getHungryTime() - 40));
        }
    }

    public void stumbleWithoutInitialAnimation() {
        this.setStumbleTicks(31);
        this.setStumbleTicksBeforeGettingUp(this.getRandom().nextIntBetweenInclusive(30, 60));
        BrainUtils.clearMemories((LivingEntity)this, (MemoryModuleType[])new MemoryModuleType[]{MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET});
    }

    public void setStumbleChance(float stumbleChance) {
        this.getEntityData().set(DATA_STUMBLE_CHANCE, (Object)Float.valueOf(stumbleChance));
    }

    public float getStumbleChance() {
        return ((Float)this.getEntityData().get(DATA_STUMBLE_CHANCE)).floatValue();
    }

    public int getShockedTime() {
        return (Integer)this.entityData.get(DATA_SHOCKED_TIME);
    }

    public void setShockedTime(int shockedTime) {
        this.entityData.set(DATA_SHOCKED_TIME, (Object)shockedTime);
        this.animationArmState = true;
    }

    public boolean isShocked() {
        return (Integer)this.entityData.get(DATA_SHOCKED_TIME) > 0;
    }

    public void setPeckTicks(int peckTime) {
        this.entityData.set(DATA_PECK_TICKS, (Object)peckTime);
    }

    public boolean isPecking() {
        return (Integer)this.entityData.get(DATA_PECK_TICKS) != Integer.MIN_VALUE;
    }

    public int getCoughTicks() {
        return (Integer)this.entityData.get(DATA_COUGH_TICKS);
    }

    public void setCoughTicks(int peckTime) {
        this.entityData.set(DATA_COUGH_TICKS, (Object)peckTime);
    }

    public boolean shouldStare() {
        return (Boolean)this.entityData.get(IS_STARING_AT_PLAYER) != false && this.onGround();
    }

    public void setIsStaringAtPlayer(boolean isStaringAtPlayer) {
        this.entityData.set(IS_STARING_AT_PLAYER, (Object)isStaringAtPlayer);
    }

    public boolean isStaringAtPlayer() {
        return (Boolean)this.entityData.get(IS_STARING_AT_PLAYER);
    }

    public boolean isCoughingUpItems() {
        return (Integer)this.entityData.get(DATA_COUGH_TICKS) != Integer.MIN_VALUE;
    }

    public int getPeckTicks() {
        return (Integer)this.entityData.get(DATA_PECK_TICKS);
    }

    public void setStumbleTicks(int stumbleTime) {
        this.entityData.set(DATA_STUMBLE_TICKS, (Object)stumbleTime);
    }

    public int getStumbleTicks() {
        return (Integer)this.entityData.get(DATA_STUMBLE_TICKS);
    }

    public void setStumbleTicksBeforeGettingUp(int ticksBeforeGettingUp) {
        this.entityData.set(DATA_STUMBLE_TICKS_BEFORE_GETTING_UP, (Object)ticksBeforeGettingUp);
    }

    public int getStumbleTicksBeforeGettingUp() {
        return (Integer)this.entityData.get(DATA_STUMBLE_TICKS_BEFORE_GETTING_UP);
    }

    public void setShoveChance(float shoveChance) {
        this.getEntityData().set(DATA_SHOVE_CHANCE, (Object)Float.valueOf(shoveChance));
    }

    public float getShoveChance() {
        return ((Float)this.getEntityData().get(DATA_SHOVE_CHANCE)).floatValue();
    }

    public void setShoveTicks(int shoveTicks) {
        this.getEntityData().set(DATA_SHOVE_TICKS, (Object)shoveTicks);
    }

    public int getShoveTicks() {
        return (Integer)this.getEntityData().get(DATA_SHOVE_TICKS);
    }

    public boolean isStumbling() {
        return this.getStumbleTicks() != Integer.MIN_VALUE;
    }

    public boolean isGettingUp() {
        return this.isStumbling() && this.getStumbleTicksBeforeGettingUp() != Integer.MIN_VALUE && this.getStumbleTicks() > 30 + this.getStumbleTicksBeforeGettingUp();
    }

    public void setEggPenguinType(String eggPenguinType) {
        this.getEntityData().set(DATA_EGG, (Object)eggPenguinType);
    }

    public boolean hasEgg() {
        return !((String)this.getEntityData().get(DATA_EGG)).isEmpty();
    }

    public Holder<PenguinVariant> getEggType() {
        Optional variant;
        ResourceLocation previousTypeKey = ResourceLocation.tryParse((String)((String)this.getEntityData().get(DATA_EGG)));
        if (previousTypeKey != null && (variant = this.level().registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getHolder(previousTypeKey)).isPresent()) {
            return (Holder)variant.get();
        }
        return this.getVariant();
    }

    public Holder<PenguinVariant> getTrueType() {
        Optional variant;
        ResourceLocation previousTypeKey;
        if (!((String)this.getEntityData().get(DATA_PREVIOUS_VARIANT)).isEmpty() && (previousTypeKey = ResourceLocation.tryParse((String)((String)this.getEntityData().get(DATA_PREVIOUS_VARIANT)))) != null && (variant = this.level().registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getHolder(previousTypeKey)).isPresent()) {
            return (Holder)variant.get();
        }
        return this.getVariant();
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public class PenguinMoveControl
    extends SmoothSwimmingMoveControl {
        private boolean moveValue;

        public PenguinMoveControl() {
            super((Mob)Penguin.this, 80, 20, 2.0f, 1.0f, false);
            this.moveValue = false;
        }

        public void tick() {
            if (this.canMove()) {
                super.tick();
                this.moveValue = true;
            } else if (this.moveValue) {
                this.mob.setXxa(0.0f);
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
                this.moveValue = false;
            }
        }

        private boolean canMove() {
            return !Penguin.this.isStumbling() && Penguin.this.getShoveTicks() == Integer.MIN_VALUE && !Penguin.this.isCoughingUpItems();
        }
    }

    public class PenguinLookControl
    extends LookControl {
        public PenguinLookControl() {
            super((Mob)Penguin.this);
        }

        public void tick() {
            if (this.canMove()) {
                super.tick();
            }
        }

        private boolean canMove() {
            return !Penguin.this.isStumbling() && Penguin.this.getShoveTicks() == Integer.MIN_VALUE;
        }
    }

    public static class PenguinGroupData
    extends AgeableMob.AgeableMobGroupData {
        public PenguinGroupData() {
            super(true);
        }

        public Holder<PenguinVariant> getSpawnVariant(BlockPos pos, ServerLevelAccessor level, RandomSource random) {
            if (Penguin.getTotalSpawnWeight((LevelAccessor)level, pos) > 0) {
                return this.getSpawnTypeDependingOnBiome(level, pos, random);
            }
            return level.registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getHolderOrThrow(RockhoppersResourceKeys.PenguinVariantKeys.ROCKHOPPER);
        }

        public Holder<PenguinVariant> getSpawnTypeDependingOnBiome(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
            ArrayList<Holder.Reference> penguinList = new ArrayList<Holder.Reference>();
            int totalWeight = 0;
            for (Holder.Reference variant : ((Registry)level.registryAccess().registry(RockhoppersResourceKeys.PENGUIN_VARIANT).orElseThrow()).holders().filter(Holder.Reference::isBound).toList()) {
                Optional<WeightedEntry.Wrapper> optional = ((PenguinVariant)variant.value()).biomes().unwrap().stream().filter(holderSetWrapper -> ((HolderSet)holderSetWrapper.data()).contains(level.getBiome(pos))).findFirst();
                if (!optional.isPresent()) continue;
                penguinList.add(variant);
                totalWeight += optional.get().weight().asInt();
            }
            if (penguinList.size() == 1) {
                return (Holder)penguinList.getFirst();
            }
            if (!penguinList.isEmpty()) {
                int r = Mth.nextInt((RandomSource)random, (int)0, (int)(totalWeight - 1));
                for (Holder holder : penguinList) {
                    int max = ((PenguinVariant)holder.value()).biomes().unwrap().stream().filter(wrapper -> ((HolderSet)wrapper.data()).contains(level.getBiome(pos))).map(wrapper -> wrapper.weight().asInt()).max(Comparator.comparingInt(value -> value)).orElse(0);
                    if (!((double)(r -= max) < 0.0)) continue;
                    return holder;
                }
            }
            return level.registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getHolderOrThrow(RockhoppersResourceKeys.PenguinVariantKeys.ROCKHOPPER);
        }
    }
}

