/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.entity;

import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.BoatLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.attachment.PlayerLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersEntityTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersItems;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BoatHookFenceKnotEntity
extends BlockAttachedEntity {
    public BoatHookFenceKnotEntity(EntityType<? extends BoatHookFenceKnotEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static BoatHookFenceKnotEntity create(Level level, BlockPos blockPos) {
        BoatHookFenceKnotEntity entity = new BoatHookFenceKnotEntity(RockhoppersEntityTypes.BOAT_HOOK_FENCE_KNOT, level);
        entity.setPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        return entity;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        boolean attachedToFence = false;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double max = 10.0;
        AABB checkBox = new AABB(x - max, y - max, z - max, x + max, y + max, z + max);
        PlayerLinksAttachment playerData = RapscallionsAndRockhoppers.getHelper().hasPlayerData(player) ? RapscallionsAndRockhoppers.getHelper().getPlayerData(player) : null;
        Set<Boat> additions = playerData != null ? playerData.getLinkedBoats(player.level()) : Set.of();
        List removals = this.level().getEntitiesOfClass(Boat.class, checkBox);
        for (Boat boat : additions) {
            BoatLinksAttachment boatData = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
            boatData.setHookKnotUuid(this.getUUID());
            boatData.setLinkedPlayerUuid(null);
            playerData.removeLinkedBoat(boat.getUUID());
            if (playerData.getLinkedBoatUUIDs().isEmpty()) {
                RapscallionsAndRockhoppers.getHelper().removePlayerData(player);
            }
            RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
            RapscallionsAndRockhoppers.getHelper().syncPlayerData(player);
            this.playPlacementSound();
            attachedToFence = true;
        }
        boolean removedFromFence = false;
        if (!attachedToFence) {
            for (Boat boat : removals) {
                BoatLinksAttachment boatData = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
                if (boatData.getHookKnot(player.level()) != this) continue;
                boatData.setHookKnotUuid(null);
                RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
                if (!boatData.hasData()) {
                    RapscallionsAndRockhoppers.getHelper().removeBoatData(boat);
                }
                RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
                removedFromFence = true;
                boat.spawnAtLocation(new ItemStack((ItemLike)RockhoppersItems.BOAT_HOOK), 1.0f);
            }
            if (!removedFromFence) {
                this.spawnAtLocation(new ItemStack((ItemLike)RockhoppersItems.BOAT_HOOK), 1.1f);
            }
            this.discard();
        }
        if (attachedToFence || removedFromFence) {
            this.gameEvent((Holder)GameEvent.BLOCK_ATTACH, (Entity)player);
        }
        return InteractionResult.CONSUME;
    }

    public static BoatHookFenceKnotEntity getOrCreate(Level level, BlockPos pos) {
        BoatHookFenceKnotEntity boathookEntity;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        Iterator boatHooks = level.getEntitiesOfClass(BoatHookFenceKnotEntity.class, new AABB((double)x - 1.0, (double)y - 1.0, (double)z - 1.0, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0)).iterator();
        do {
            if (boatHooks.hasNext()) continue;
            BoatHookFenceKnotEntity newBoatKnot = BoatHookFenceKnotEntity.create(level, pos);
            level.addFreshEntity((Entity)newBoatKnot);
            return newBoatKnot;
        } while (!(boathookEntity = (BoatHookFenceKnotEntity)((Object)boatHooks.next())).getPos().equals((Object)pos));
        return boathookEntity;
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.LEASH_KNOT_PLACE, 1.0f, 1.0f);
    }

    public Vec3 getRopeHoldPosition(float partialTicks) {
        return this.getPosition(partialTicks).add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0);
    }

    protected void recalculateBoundingBox() {
        this.setPosRaw((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.375, (double)this.pos.getZ() + 0.5);
        double d0 = (double)this.getType().getWidth() / 2.0;
        double d1 = this.getType().getHeight();
        this.setBoundingBox(new AABB(this.getX() - d0, this.getY(), this.getZ() - d0, this.getX() + d0, this.getY() + d1, this.getZ() + d0));
    }

    public boolean survives() {
        return this.level().getBlockState(this.pos).is(BlockTags.FENCES);
    }

    public void dropItem(@Nullable Entity entity) {
        this.playSound(SoundEvents.LEASH_KNOT_BREAK, 1.0f, 1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 1024.0;
    }

    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)RockhoppersItems.BOAT_HOOK);
    }
}

