/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.client.renderer.model;

import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.client.renderer.model.PenguinAnimation;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class PenguinModel
extends AgeableHierarchicalModel<Penguin> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(RapscallionsAndRockhoppers.asResource("penguin"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart brows;
    private final ModelPart belly;

    public PenguinModel(ModelPart root) {
        super(0.5f, 24.0f);
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.brows = this.head.getChild("brows");
        this.belly = this.body.getChild("body2");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.5f, (float)0.5f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 14).addBox(-4.5f, -5.5f, -3.5f, 9.0f, 11.0f, 7.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = body.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(7, 23).addBox(-3.5f, -2.5f, -4.5f, 7.0f, 8.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.0f, -3.5f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-0.5f, 0.001f, -5.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.5f, (float)0.0f));
        PartDefinition brows = head.addOrReplaceChild("brows", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.5f, (float)-1.25f));
        brows.addOrReplaceChild("leftBrow", CubeListBuilder.create().texOffs(28, 0).addBox(-1.5f, -1.5f, -2.5f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-2.5f, (float)-1.25f));
        brows.addOrReplaceChild("rightBrow", CubeListBuilder.create().texOffs(28, 0).mirror().addBox(-1.5f, -1.5f, -2.5f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)-2.5f, (float)-1.25f));
        body.addOrReplaceChild("leftFlipper", CubeListBuilder.create().texOffs(32, 20).addBox(0.001f, 0.001f, -1.5f, 1.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)-5.5f, (float)0.0f));
        body.addOrReplaceChild("rightFlipper", CubeListBuilder.create().texOffs(32, 20).addBox(-1.0f, 0.001f, -1.5f, 1.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)-5.5f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(25, 15).addBox(-2.5f, -0.75f, -0.75f, 5.0f, 0.001f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.5f, (float)3.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("leftFoot", CubeListBuilder.create().texOffs(28, 10).addBox(-1.5f, 0.001f, -3.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(32, 8).addBox(-1.5f, 2.0f, -5.0f, 3.0f, 0.001f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)4.5f, (float)1.5f));
        root.addOrReplaceChild("rightFoot", CubeListBuilder.create().texOffs(28, 10).mirror().addBox(-1.5f, 0.001f, -3.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(32, 8).addBox(-1.5f, 2.0f, -5.0f, 3.0f, 0.001f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)4.5f, (float)1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(Penguin penguin, float limbSwing, float limbSwingAmount, float delta, float yRot, float xRot) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.scaleBabyHead();
        if (penguin.isShocked()) {
            this.brows.setPos(0.0f, -0.75f, 0.0f);
        } else {
            this.brows.setPos(0.0f, 0.0f, 0.0f);
        }
        this.animateWaddle(penguin, delta, limbSwing, limbSwingAmount, penguin.isShocked() ? 1.4f : 1.0f);
        this.animate(penguin.shockArmAnimationState, PenguinAnimation.SHOCK_ARMS, delta, 1.25f);
        this.animateStumble(penguin, delta);
        this.animate(penguin.shoveAnimationState, PenguinAnimation.SHOVE, delta, 1.0f);
        this.animateBodyInWater(penguin, yRot, xRot);
        this.animateSwim(penguin, delta);
        this.animate(penguin.peckAnimationState, PenguinAnimation.PECK, delta, 1.0f);
        this.animate(penguin.coughUpAnimationState, PenguinAnimation.COUGH_UP, delta, 0.5f);
        this.animate(penguin.stareAnimationState, PenguinAnimation.STARE, delta, 1.0f);
        this.animateHeadTowardsLookTarget(penguin, yRot, xRot);
        this.belly.visible = penguin.hasEgg();
    }

    protected void animateWaddle(Penguin penguin, float delta, float limbSwing, float limbSwingAmount, float animationSpeed) {
        this.animate(penguin.idleAnimationState, PenguinAnimation.IDLE, delta, animationSpeed * 0.5f);
        this.animate(penguin.waddleAnimationState, PenguinAnimation.WADDLE_BODY, delta, animationSpeed);
        this.animate(penguin.waddleArmEaseInAnimationState, PenguinAnimation.WADDLE_ARMS_EASE_IN, delta, animationSpeed);
        this.animate(penguin.waddleArmEaseOutAnimationState, PenguinAnimation.WADDLE_ARMS_EASE_OUT, delta, animationSpeed);
        this.animateWalk(PenguinAnimation.WADDLE_FEET, limbSwing, limbSwingAmount, 5.0f, 45.0f);
    }

    protected void animateStumble(Penguin penguin, float delta) {
        this.animate(penguin.stumbleAnimationState, PenguinAnimation.STUMBLE, delta, 1.0f);
        this.animate(penguin.stumbleGroundAnimationState, PenguinAnimation.STUMBLE_LAND, delta, 1.0f);
        this.animate(penguin.stumbleFallingAnimationState, PenguinAnimation.SHOCK_ARMS, delta, 1.0f);
        this.animate(penguin.stumbleGetUpAnimationState, PenguinAnimation.GET_UP, delta, 1.0f);
    }

    protected void scaleBabyHead() {
        if (!this.young) {
            return;
        }
        this.head.xScale *= 1.3f;
        this.head.yScale *= 1.3f;
        this.head.zScale *= 1.3f;
    }

    protected void animateSwim(Penguin penguin, float delta) {
        this.animate(penguin.swimIdleAnimationState, PenguinAnimation.SWIM_IDLE, delta, 1.0f);
        this.animate(penguin.swimAnimationState, PenguinAnimation.SWIM, delta, 0.25f);
        this.animate(penguin.swimEaseInAnimationState, PenguinAnimation.SWIM_EASE_IN, delta, 1.0f);
        this.animate(penguin.swimEaseOutAnimationState, PenguinAnimation.SWIM_EASE_OUT, delta, 1.0f);
    }

    protected void animateHeadTowardsLookTarget(Penguin penguin, float yRot, float xRot) {
        if (!this.canAnimateHead(penguin)) {
            return;
        }
        this.head.xRot = xRot * ((float)Math.PI / 180);
        this.head.yRot = yRot * ((float)Math.PI / 180);
    }

    protected void animateBodyInWater(Penguin penguin, float yRot, float xRot) {
        if (!this.canRotateBodyInWater(penguin)) {
            return;
        }
        this.root.xRot = (float)((double)xRot * Math.PI / 180.0);
        this.root.yRot = (float)((double)yRot * Math.PI / 180.0);
    }

    protected boolean canAnimateHead(Penguin penguin) {
        return !penguin.isStumbling() && !this.canRotateBodyInWater(penguin);
    }

    protected boolean canRotateBodyInWater(Penguin penguin) {
        return penguin.swimAnimationState.isStarted();
    }
}

