/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.client.renderer;

import house.greenhouse.rapscallionsandrockhoppers.client.renderer.model.PenguinModel;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.entity.PenguinVariant;
import house.greenhouse.rapscallionsandrockhoppers.util.RockhoppersResourceKeys;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class PenguinRenderer
extends MobRenderer<Penguin, PenguinModel> {
    private static final Map<ResourceLocation, Boolean> PENGUIN_TEXTURE_CACHE = new HashMap<ResourceLocation, Boolean>();

    public PenguinRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PenguinModel(context.bakeLayer(PenguinModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(Penguin penguin) {
        if (penguin.isShocked() || penguin.isStumbling() && !penguin.isGettingUp()) {
            ResourceLocation textureLocation = ((PenguinVariant)penguin.getVariant().value()).surprisedTexture().withPath(path -> "textures/" + path + ".png");
            this.addToTextureCache(textureLocation);
            if (PENGUIN_TEXTURE_CACHE.getOrDefault(textureLocation, false).booleanValue()) {
                return textureLocation;
            }
        } else {
            ResourceLocation textureLocation = ((PenguinVariant)penguin.getVariant().value()).texture().withPath(path -> "textures/" + path + ".png");
            this.addToTextureCache(textureLocation);
            if (PENGUIN_TEXTURE_CACHE.getOrDefault(textureLocation, false).booleanValue()) {
                return textureLocation;
            }
        }
        return ((PenguinVariant)penguin.level().registryAccess().registryOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getOrThrow(RockhoppersResourceKeys.PenguinVariantKeys.ROCKHOPPER)).texture();
    }

    private void addToTextureCache(ResourceLocation textureLocation) {
        PENGUIN_TEXTURE_CACHE.computeIfAbsent(textureLocation, tl -> Minecraft.getInstance().getResourceManager().getResource(tl).isPresent());
    }
}

