/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.block.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.entity.PenguinVariant;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersBlockEntityTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersDataComponents;
import house.greenhouse.rapscallionsandrockhoppers.util.RockhoppersResourceKeys;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PenguinEggBlockEntity
extends BlockEntity {
    public Holder<PenguinVariant> babyVariant;

    public PenguinEggBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(RockhoppersBlockEntityTypes.PENGUIN_EGG, blockPos, blockState);
    }

    public void setTypeFromParents(Penguin parent1, Penguin parent2) {
        if (this.getLevel() == null) {
            return;
        }
        this.setPenguinVariant(this.getLevel().random.nextBoolean() ? parent1.getTrueType() : parent2.getTrueType());
    }

    public void setPenguinVariant(Holder<PenguinVariant> variant) {
        this.babyVariant = variant;
    }

    public Holder<PenguinVariant> getPenguinVariant() {
        return this.babyVariant;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.babyVariant != null) {
            tag.put("penguin_type", (Tag)PenguinVariant.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), this.babyVariant).getOrThrow());
        } else {
            tag.put("penguin_type", (Tag)PenguinVariant.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), (Object)registries.lookupOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getOrThrow(RockhoppersResourceKeys.PenguinVariantKeys.ROCKHOPPER)).getOrThrow());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.babyVariant = tag.contains("penguin_type") ? (Holder)((Pair)PenguinVariant.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), (Object)tag.get("penguin_type")).getOrThrow()).getFirst() : registries.lookupOrThrow(RockhoppersResourceKeys.PENGUIN_VARIANT).getOrThrow(RockhoppersResourceKeys.PenguinVariantKeys.ROCKHOPPER);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(RockhoppersDataComponents.PENGUIN_TYPE, this.babyVariant);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.babyVariant = (Holder)componentInput.getOrDefault(RockhoppersDataComponents.PENGUIN_TYPE, this.babyVariant);
    }
}

