/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.block;

import house.greenhouse.rapscallionsandrockhoppers.block.entity.PenguinEggBlockEntity;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.entity.PenguinVariant;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PenguinEggBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    private static final VoxelShape PENGUIN_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;

    public PenguinEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        EntityCollisionContext entityCollisionContext;
        if (collisionContext instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)collisionContext).getEntity() instanceof Penguin) {
            return this.hasCollision ? PENGUIN_SHAPE : Shapes.empty();
        }
        return this.hasCollision ? state.getShape(blockGetter, blockPos) : Shapes.empty();
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{HATCH});
    }

    public static void crackEgg(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos) {
        int hatch = (Integer)blockState.getValue((Property)HATCH);
        if (hatch < 2) {
            serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)HATCH, (Comparable)Integer.valueOf(hatch + 1)), 2);
        } else {
            Penguin penguin = (Penguin)RockhoppersEntityTypes.PENGUIN.create((Level)serverLevel);
            if (penguin == null) {
                return;
            }
            penguin.setAge(-24000);
            penguin.moveTo((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
            BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos);
            if (blockEntity instanceof PenguinEggBlockEntity) {
                PenguinEggBlockEntity penguinEggBlockEntity = (PenguinEggBlockEntity)blockEntity;
                Holder<PenguinVariant> penguinType = penguinEggBlockEntity.getPenguinVariant();
                penguin.setVariant(penguinType);
            }
            serverLevel.addFreshEntity((Entity)penguin);
            serverLevel.removeBlock(blockPos, false);
        }
        serverLevel.addDestroyBlockEffect(blockPos, blockState);
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.nextInt(600) == 0) {
            PenguinEggBlock.crackEgg(blockState, serverLevel, blockPos);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PenguinEggBlockEntity(blockPos, blockState);
    }
}

