/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.util.EntityGetUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;

public class PlayerLinksAttachment {
    public static final ResourceLocation ID = RapscallionsAndRockhoppers.asResource("boat_hook_player");
    private Set<UUID> linkedBoats;
    public static final Codec<PlayerLinksAttachment> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)UUIDUtil.CODEC_SET.fieldOf("linked_boats").forGetter(PlayerLinksAttachment::getLinkedBoatUUIDs)).apply((Applicative)inst, PlayerLinksAttachment::new));

    public PlayerLinksAttachment() {
        this.linkedBoats = new HashSet<UUID>();
    }

    public void setFrom(PlayerLinksAttachment other) {
        this.linkedBoats = other.linkedBoats;
    }

    public PlayerLinksAttachment(Set<UUID> linkedBoats) {
        this.linkedBoats = linkedBoats;
    }

    public Set<UUID> getLinkedBoatUUIDs() {
        return this.linkedBoats;
    }

    public void addLinkedBoat(UUID boat) {
        this.linkedBoats.add(boat);
    }

    public void removeLinkedBoat(UUID boat) {
        this.linkedBoats.remove(boat);
    }

    public void clearLinkedBoats() {
        this.linkedBoats.clear();
    }

    public Set<Boat> getLinkedBoats(Level level) {
        return this.getLinkedBoatUUIDs().stream().map(uuid -> {
            Entity entity = EntityGetUtil.getEntityFromUuid(level, uuid);
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                return boat;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void invalidateNonExistentBoats(Level level) {
        this.getLinkedBoatUUIDs().removeIf(uuid -> this.getLinkedBoats(level).stream().noneMatch(boat -> boat.getUUID() == uuid && !boat.isRemoved()));
    }

    public void deserializeLegacyData(CompoundTag tag) {
        this.clearLinkedBoats();
        if (tag.contains("linked_boat", 9)) {
            ListTag linkedBoats = tag.getList("linked_boat", 11);
            for (Tag linkedBoat : linkedBoats) {
                this.addLinkedBoat(NbtUtils.loadUUID((Tag)linkedBoat));
            }
        }
    }
}

