/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.Nullable;

public class BoatPenguinsAttachment {
    public static final ResourceLocation ID = RapscallionsAndRockhoppers.asResource("boat_penguins");
    private Set<UUID> penguins;
    @Nullable
    private Boat instance;
    public static final Codec<BoatPenguinsAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC_SET.fieldOf("penguins").forGetter(BoatPenguinsAttachment::getFollowingPenguins)).apply((Applicative)instance, BoatPenguinsAttachment::new));

    public BoatPenguinsAttachment() {
        this.penguins = new HashSet<UUID>();
    }

    public BoatPenguinsAttachment(Set<UUID> penguins) {
        this.penguins = penguins;
    }

    public void setFrom(BoatPenguinsAttachment other) {
        this.penguins = other.penguins;
    }

    public Set<UUID> getFollowingPenguins() {
        return Set.copyOf(this.penguins);
    }

    public int penguinCount() {
        return this.penguins.size();
    }

    public void addFollowingPenguin(UUID penguinUUID) {
        this.penguins.add(penguinUUID);
    }

    public void removeFollowingPenguin(UUID penguinUUID) {
        this.penguins.remove(penguinUUID);
    }

    @Nullable
    public Boat getProvider() {
        return this.instance;
    }

    public void setProvider(Boat boat) {
        if (this.instance != null) {
            return;
        }
        this.instance = boat;
    }

    public void sync() {
        if (this.getProvider() == null || this.getProvider().level().isClientSide()) {
            return;
        }
        RapscallionsAndRockhoppers.getHelper().syncBoatPenguinData(this.getProvider());
    }

    public void clearFollowingPenguins() {
        this.penguins.clear();
    }
}

