/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.PlayerLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.entity.BoatHookFenceKnotEntity;
import house.greenhouse.rapscallionsandrockhoppers.mixin.BoatAccessor;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersItems;
import house.greenhouse.rapscallionsandrockhoppers.util.EntityGetUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BoatLinksAttachment {
    public static final ResourceLocation ID = RapscallionsAndRockhoppers.asResource("boat_links");
    private static final double HOOK_DAMPENING_FACTOR = 0.2;
    private final Set<UUID> nextLinkedBoats;
    private final Set<UUID> previousLinkedBoats;
    private Optional<UUID> linkedPlayerUuid = Optional.empty();
    private Optional<UUID> hookKnotUuid = Optional.empty();
    private long lastMovementTime;
    public static final Codec<BoatLinksAttachment> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)UUIDUtil.CODEC_SET.fieldOf("linked_boats_after").forGetter(BoatLinksAttachment::getNextLinkedBoatUuids), (App)UUIDUtil.CODEC_SET.fieldOf("linked_boats_before").forGetter(BoatLinksAttachment::getPreviousLinkedBoatUuids), (App)UUIDUtil.CODEC.optionalFieldOf("linked_player").forGetter(BoatLinksAttachment::getLinkedPlayerUuid), (App)UUIDUtil.CODEC.optionalFieldOf("hook_knot_uuid").forGetter(BoatLinksAttachment::getHookKnotUuid)).apply((Applicative)inst, BoatLinksAttachment::new));

    public BoatLinksAttachment() {
        this.nextLinkedBoats = new HashSet<UUID>();
        this.previousLinkedBoats = new HashSet<UUID>();
    }

    public BoatLinksAttachment(Set<UUID> nextLinkedBoats, Set<UUID> previousLinkedBoats, Optional<UUID> linkedPlayerUuid, Optional<UUID> hookKnotUuid) {
        this.nextLinkedBoats = nextLinkedBoats;
        this.previousLinkedBoats = previousLinkedBoats;
        this.linkedPlayerUuid = linkedPlayerUuid;
        this.hookKnotUuid = hookKnotUuid;
    }

    public void setFrom(BoatLinksAttachment other) {
        this.nextLinkedBoats.clear();
        this.previousLinkedBoats.clear();
        this.nextLinkedBoats.addAll(other.nextLinkedBoats);
        this.previousLinkedBoats.addAll(other.previousLinkedBoats);
        this.linkedPlayerUuid = other.linkedPlayerUuid;
        this.hookKnotUuid = other.hookKnotUuid;
    }

    public boolean hasData() {
        return !this.previousLinkedBoats.isEmpty() || !this.nextLinkedBoats.isEmpty() || this.hookKnotUuid.isPresent() || this.linkedPlayerUuid != null;
    }

    public Set<UUID> getNextLinkedBoatUuids() {
        return this.nextLinkedBoats;
    }

    public Set<UUID> getPreviousLinkedBoatUuids() {
        return this.previousLinkedBoats;
    }

    public void clearNextLinkedBoatUuids() {
        this.nextLinkedBoats.clear();
    }

    public void clearPreviousLinkedBoatUuids() {
        this.previousLinkedBoats.clear();
    }

    public Optional<UUID> getLinkedPlayerUuid() {
        return this.linkedPlayerUuid;
    }

    public void setLinkedPlayerUuid(@Nullable UUID player) {
        this.linkedPlayerUuid = Optional.ofNullable(player);
    }

    public void addNextLinkedBoat(@Nullable UUID boat) {
        this.nextLinkedBoats.add(boat);
    }

    public void removeNextLinkedBoat(@Nullable UUID boat) {
        this.nextLinkedBoats.remove(boat);
    }

    public void addPreviousLinkedBoat(@Nullable UUID boat) {
        this.previousLinkedBoats.add(boat);
    }

    public void removePreviousLinkedBoat(@Nullable UUID boat) {
        this.previousLinkedBoats.remove(boat);
    }

    public Optional<UUID> getHookKnotUuid() {
        return this.hookKnotUuid;
    }

    public void setHookKnotUuid(@Nullable UUID hookKnotUuid) {
        this.hookKnotUuid = Optional.ofNullable(hookKnotUuid);
    }

    public Set<Boat> getNextLinkedBoats(Level level) {
        return this.getNextLinkedBoatUuids().stream().map(uuid -> {
            Entity entity = EntityGetUtil.getEntityFromUuid(level, uuid);
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                return boat;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<Boat> getPreviousLinkedBoats(Level level) {
        return this.getPreviousLinkedBoatUuids().stream().map(uuid -> {
            Entity entity = EntityGetUtil.getEntityFromUuid(level, uuid);
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                return boat;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    public Player getLinkedPlayer(Level level) {
        Entity entity = EntityGetUtil.getEntityFromUuid(level, this.linkedPlayerUuid.orElse(null));
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    @Nullable
    public BoatHookFenceKnotEntity getHookKnot(Level level) {
        Entity entity = EntityGetUtil.getEntityFromUuid(level, this.hookKnotUuid.orElse(null));
        if (entity instanceof BoatHookFenceKnotEntity) {
            BoatHookFenceKnotEntity knot = (BoatHookFenceKnotEntity)entity;
            return knot;
        }
        return null;
    }

    public static boolean canLinkTo(Boat boat, Boat otherBoat) {
        BoatLinksAttachment boatData = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
        BoatLinksAttachment otherBoatData = RapscallionsAndRockhoppers.getHelper().getBoatData(otherBoat);
        return !boatData.getPreviousLinkedBoats(boat.level()).contains(otherBoat) && !boatData.getNextLinkedBoats(boat.level()).contains(otherBoat) && !otherBoatData.getPreviousLinkedBoats(otherBoat.level()).contains(boat) && !otherBoatData.getNextLinkedBoats(otherBoat.level()).contains(boat);
    }

    public static InteractionResult handleInteractionWithBoatHook(Boat boat, Player player, InteractionHand interactionHand) {
        BoatLinksAttachment boatData = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
        PlayerLinksAttachment playerData = RapscallionsAndRockhoppers.getHelper().getPlayerData(player);
        if (boatData.getLinkedPlayer(boat.level()) == player) {
            boatData.setLinkedPlayerUuid(null);
            playerData.removeLinkedBoat(boat.getUUID());
            if (!boatData.hasData()) {
                RapscallionsAndRockhoppers.getHelper().removeBoatData(boat);
            }
            if (!playerData.getLinkedBoatUUIDs().isEmpty()) {
                RapscallionsAndRockhoppers.getHelper().removePlayerData(player);
            }
            if (!boat.level().isClientSide) {
                RapscallionsAndRockhoppers.getHelper().syncPlayerData(player);
                RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
            }
            if (!player.getAbilities().instabuild) {
                boat.spawnAtLocation(new ItemStack((ItemLike)RockhoppersItems.BOAT_HOOK), 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.getItemInHand(interactionHand).is(RockhoppersItems.BOAT_HOOK) && (playerData.getLinkedBoats(player.level()).isEmpty() && boatData.getPreviousLinkedBoats(boat.level()).isEmpty() && boatData.getNextLinkedBoats(boat.level()).isEmpty() || player.isShiftKeyDown())) {
            boatData.setLinkedPlayerUuid(player.getUUID());
            playerData.addLinkedBoat(boat.getUUID());
            if (!boat.level().isClientSide) {
                RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
                RapscallionsAndRockhoppers.getHelper().syncPlayerData(player);
            }
            if (!player.getAbilities().instabuild) {
                player.getItemInHand(interactionHand).shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (boatData.getLinkedPlayer(boat.level()) == null && !playerData.getLinkedBoats(player.level()).isEmpty()) {
            Set<Boat> otherBoats = playerData.getLinkedBoats(player.level());
            for (Boat otherBoat : otherBoats) {
                BoatLinksAttachment otherBoatData = RapscallionsAndRockhoppers.getHelper().getBoatData(otherBoat);
                if (otherBoat.is((Entity)boat) || !BoatLinksAttachment.canLinkTo(boat, otherBoat) || otherBoatData.getLinkedPlayer(boat.level()) != player) continue;
                otherBoatData.addPreviousLinkedBoat(boat.getUUID());
                boatData.addNextLinkedBoat(otherBoat.getUUID());
                otherBoatData.setLinkedPlayerUuid(null);
                playerData.removeLinkedBoat(otherBoat.getUUID());
                if (!boat.level().isClientSide) {
                    RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
                    RapscallionsAndRockhoppers.getHelper().syncBoatData(otherBoat);
                    RapscallionsAndRockhoppers.getHelper().syncPlayerData(player);
                }
                boat.playSound(SoundEvents.LEASH_KNOT_PLACE, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void addBoatMovementCode(Boat boat) {
        BoatHookFenceKnotEntity knot;
        float distanceBetween;
        if (boat == null || boat.level().isClientSide()) {
            return;
        }
        BoatLinksAttachment data = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
        if (data.getLinkedPlayer(boat.level()) != null) {
            float distanceBetween2 = data.getLinkedPlayer(boat.level()).distanceTo((Entity)boat);
            if (distanceBetween2 < 10.0f) {
                BoatLinksAttachment.moveTowardsNonBoat(boat, (Entity)data.getLinkedPlayer(boat.level()));
            }
            if (distanceBetween2 > 10.0f || !data.getLinkedPlayer(boat.level()).isAlive()) {
                boat.spawnAtLocation(new ItemStack((ItemLike)RockhoppersItems.BOAT_HOOK), 1.0f);
                data.setLinkedPlayerUuid(null);
            }
        }
        if (data.getHookKnot(boat.level()) != null && (distanceBetween = (knot = data.getHookKnot(boat.level())).distanceTo((Entity)boat)) > 10.0f) {
            boat.spawnAtLocation(new ItemStack((ItemLike)RockhoppersItems.BOAT_HOOK), 1.0f);
            data.setHookKnotUuid(null);
            RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
        }
        if (boat.getPaddleState(0) || boat.getPaddleState(1)) {
            data.lastMovementTime = boat.level().getGameTime();
        }
        BoatLinksAttachment.moveTowardsBoats(boat, data.getNextLinkedBoatUuids(), data.getPreviousLinkedBoatUuids());
    }

    private static void moveTowardsBoats(Boat boat, Set<UUID> nextUuids, Set<UUID> previousUuids) {
        BoatLinksAttachment data = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
        if (!nextUuids.isEmpty()) {
            for (Pair next : nextUuids.stream().map(uuid1 -> {
                Entity patt0$temp = ((ServerLevel)boat.level()).getEntity(uuid1);
                if (patt0$temp instanceof Boat) {
                    Boat other = (Boat)patt0$temp;
                    return Pair.of((Object)uuid1, (Object)other);
                }
                return Pair.of((Object)uuid1, (Object)null);
            }).toList()) {
                if (next.getSecond() == null || ((Boat)next.getSecond()).isRemoved() || ((Boat)next.getSecond()).distanceTo((Entity)boat) > 16.0f) {
                    if (next.getSecond() != null) {
                        BoatLinksAttachment nextBoatData = RapscallionsAndRockhoppers.getHelper().getBoatData((Boat)next.getSecond());
                        nextBoatData.removePreviousLinkedBoat(boat.getUUID());
                        if (!nextBoatData.hasData()) {
                            RapscallionsAndRockhoppers.getHelper().removeBoatData((Boat)next.getSecond());
                        }
                        RapscallionsAndRockhoppers.getHelper().syncBoatData((Boat)next.getSecond());
                    }
                    boat.spawnAtLocation(new ItemStack((ItemLike)RockhoppersItems.BOAT_HOOK), 1.0f);
                    data.removeNextLinkedBoat((UUID)next.getFirst());
                    if (!data.hasData()) {
                        RapscallionsAndRockhoppers.getHelper().removeBoatData(boat);
                    }
                    RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
                    return;
                }
                BoatLinksAttachment.doBoatLinkedMovementTo(boat, (Boat)next.getSecond());
            }
        }
        if (!previousUuids.isEmpty()) {
            for (Pair previous : previousUuids.stream().map(uuid1 -> {
                Entity patt0$temp = ((ServerLevel)boat.level()).getEntity(uuid1);
                if (patt0$temp instanceof Boat) {
                    Boat previous = (Boat)patt0$temp;
                    return Pair.of((Object)uuid1, (Object)previous);
                }
                return Pair.of((Object)uuid1, (Object)null);
            }).toList()) {
                if (previous.getSecond() == null || ((Boat)previous.getSecond()).isRemoved() || ((Boat)previous.getSecond()).distanceTo((Entity)boat) > 16.0f) {
                    if (previous.getSecond() != null) {
                        BoatLinksAttachment nextBoatData = RapscallionsAndRockhoppers.getHelper().getBoatData((Boat)previous.getSecond());
                        nextBoatData.removeNextLinkedBoat(boat.getUUID());
                        if (!nextBoatData.hasData()) {
                            RapscallionsAndRockhoppers.getHelper().removeBoatData((Boat)previous.getSecond());
                        }
                        RapscallionsAndRockhoppers.getHelper().syncBoatData((Boat)previous.getSecond());
                    }
                    boat.spawnAtLocation(new ItemStack((ItemLike)RockhoppersItems.BOAT_HOOK), 1.0f);
                    data.removePreviousLinkedBoat((UUID)previous.getFirst());
                    if (!data.hasData()) {
                        RapscallionsAndRockhoppers.getHelper().removeBoatData(boat);
                    }
                    RapscallionsAndRockhoppers.getHelper().syncBoatData(boat);
                    return;
                }
                BoatLinksAttachment.doBoatLinkedMovementTo(boat, (Boat)previous.getSecond());
            }
        }
    }

    private static void doBoatLinkedMovementTo(Boat boat, Boat other) {
        if (RapscallionsAndRockhoppers.getHelper().getBoatData((Boat)boat).lastMovementTime >= RapscallionsAndRockhoppers.getHelper().getBoatData((Boat)other).lastMovementTime || boat.hasControllingPassenger()) {
            return;
        }
        Vec3 thisPos = boat.position();
        Vec3 otherPos = other.position();
        float distanceBetween = other.distanceTo((Entity)boat);
        if (distanceBetween <= 3.0f || distanceBetween > 16.0f) {
            return;
        }
        float distanceFactor = (distanceBetween - 3.0f) / 7.0f;
        Vec3 betweenVec = thisPos.vectorTo(otherPos).scale(0.2);
        Vec3 thisDelta = betweenVec.normalize().scale((double)distanceBetween).scale((double)distanceFactor);
        thisDelta.multiply(1.0, 0.0, 1.0);
        thisDelta.add(0.0, boat.getDeltaMovement().y(), 0.0);
        boat.setDeltaMovement(thisDelta);
        if (!(!(boat.getDeltaMovement().horizontalDistance() > 0.05) || boat.hasControllingPassenger() && boat.getControllingPassenger() instanceof Player)) {
            float cross = (float)otherPos.subtract(thisPos).cross(boat.getForward()).y() * 1.4f;
            boat.setYRot(boat.getYRot() + cross);
        }
    }

    public static void moveTowardsNonBoat(Boat boat, Entity other) {
        Vec3 thisPos = boat.position();
        Vec3 otherPos = other.position();
        if (other.getDeltaMovement().horizontalDistance() > 0.05) {
            float cross = (float)otherPos.subtract(thisPos).cross(boat.getForward()).y();
            boat.setYRot(boat.getYRot() + cross);
        }
        if (boat.level().isClientSide()) {
            return;
        }
        double distanceBetween = other.position().multiply(1.0, 0.0, 1.0).distanceTo(boat.position().multiply(1.0, 0.0, 1.0));
        if (distanceBetween > 2.0) {
            double distanceFactor = (distanceBetween - 2.0) / 7.0;
            Vec3 delta = boat.position().vectorTo(other.position()).normalize().scale(distanceBetween).scale(distanceFactor).multiply(1.0, other.getY() - boat.getY() > (double)1.8f ? 1.0 : 0.0, 1.0);
            if (((BoatAccessor)boat).rapscallionsandrockhoppers$getStatus() != null && ((BoatAccessor)boat).rapscallionsandrockhoppers$getStatus().equals((Object)Boat.Status.IN_WATER) && delta.y() < 0.0) {
                delta = new Vec3(delta.x(), boat.getDeltaMovement().y(), delta.z());
            }
            boat.setDeltaMovement(delta);
        }
        if (!(!(boat.getDeltaMovement().horizontalDistance() > 0.05) || boat.hasControllingPassenger() && boat.getControllingPassenger() instanceof Player)) {
            float cross = (float)otherPos.subtract(thisPos).cross(boat.getForward()).y() * 2.4f;
            boat.setYRot(boat.getYRot() + cross);
        }
    }

    public void deserializeLegacyData(CompoundTag tag) {
        ListTag boats;
        this.clearNextLinkedBoatUuids();
        if (tag.contains("next_linked_boats", 9)) {
            boats = tag.getList("next_linked_boats", 11);
            for (Tag boat : boats) {
                this.addNextLinkedBoat(NbtUtils.loadUUID((Tag)boat));
            }
        }
        this.clearPreviousLinkedBoatUuids();
        if (tag.contains("previous_linked_boats", 9)) {
            boats = tag.getList("previous_linked_boats", 11);
            for (Tag boat : boats) {
                this.addPreviousLinkedBoat(NbtUtils.loadUUID((Tag)boat));
            }
        }
    }
}

